/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.instance.utils;

import java.util.ArrayList;
import java.util.HashMap;
import org.javarosa.core.model.instance.FormInstance;
import org.javarosa.core.model.instance.utils.CompactInstanceWrapper;
import org.javarosa.core.model.instance.utils.InstanceTemplateManager;

public class CachingInstanceTemplateManager
implements InstanceTemplateManager {
    private HashMap<Integer, FormInstance> templateCache = new HashMap();
    private ArrayList<Integer> allowedFormTypes;
    private boolean restrictFormTypes;

    public CachingInstanceTemplateManager() {
        this(true);
    }

    public CachingInstanceTemplateManager(boolean restrictFormTypes) {
        this.restrictFormTypes = restrictFormTypes;
        this.allowedFormTypes = new ArrayList(0);
    }

    public void clearCache() {
        this.templateCache.clear();
    }

    public void addFormType(int formID) {
        if (!this.allowedFormTypes.contains(formID)) {
            this.allowedFormTypes.add(formID);
        }
    }

    public void resetFormTypes() {
        this.allowedFormTypes.clear();
    }

    @Override
    public FormInstance getTemplateInstance(int formID) {
        if (this.restrictFormTypes && !this.allowedFormTypes.contains(formID)) {
            throw new RuntimeException("form ID [" + formID + "] is not an allowed form type!");
        }
        FormInstance template = this.templateCache.get(formID);
        if (template == null) {
            template = CompactInstanceWrapper.loadTemplateInstance(formID);
            if (template == null) {
                throw new RuntimeException("no formdef found for form id [" + formID + "]");
            }
            this.templateCache.put(formID, template);
        }
        return template;
    }
}

