/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.javarosa.core.model.IDag;
import org.javarosa.core.model.QuickTriggerable;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.instance.FormInstance;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.debug.EvaluationResult;
import org.javarosa.debug.Event;

public abstract class LatestDagBase
extends IDag {
    protected LatestDagBase(IDag.EventNotifierAccessor accessor) {
        super(accessor);
    }

    protected Set<QuickTriggerable> doEvaluateTriggerables(FormInstance mainInstance, EvaluationContext evalContext, Set<QuickTriggerable> tv, TreeReference anchorRef, Set<QuickTriggerable> alreadyEvaluated) {
        HashSet<QuickTriggerable> fired = new HashSet<QuickTriggerable>();
        LinkedHashMap<TreeReference, List<TreeReference>> firedAnchors = new LinkedHashMap<TreeReference, List<TreeReference>>();
        for (QuickTriggerable qt : this.triggerablesDAG) {
            List<EvaluationResult> evaluationResults;
            if (!tv.contains(qt) || alreadyEvaluated.contains(qt)) continue;
            List<TreeReference> affectedTriggers = qt.t.findAffectedTriggers(firedAnchors);
            if (affectedTriggers.isEmpty()) {
                affectedTriggers.add(anchorRef);
            }
            if ((evaluationResults = this.evaluateTriggerable(mainInstance, evalContext, qt, affectedTriggers)).size() > 0) {
                fired.add(qt);
                for (EvaluationResult evaluationResult : evaluationResults) {
                    TreeReference affectedRef = evaluationResult.getAffectedRef();
                    TreeReference key = affectedRef.genericize();
                    ArrayList<TreeReference> values = (ArrayList<TreeReference>)firedAnchors.get(key);
                    if (values == null) {
                        values = new ArrayList<TreeReference>();
                        firedAnchors.put(key, values);
                    }
                    values.add(affectedRef);
                }
            }
            fired.add(qt);
        }
        return fired;
    }

    private List<EvaluationResult> evaluateTriggerable(FormInstance mainInstance, EvaluationContext evalContext, QuickTriggerable qt, List<TreeReference> anchorRefs) {
        ArrayList<EvaluationResult> evaluationResults = new ArrayList<EvaluationResult>(0);
        HashSet<TreeReference> updatedContextRef = new HashSet<TreeReference>();
        for (TreeReference anchorRef : anchorRefs) {
            TreeReference contextRef = qt.t.contextualizeContextRef(anchorRef);
            if (updatedContextRef.contains(contextRef)) continue;
            try {
                boolean fired;
                List<TreeReference> qualifiedList = evalContext.expandReference(contextRef);
                for (TreeReference qualified : qualifiedList) {
                    EvaluationContext ec = new EvaluationContext(evalContext, qualified);
                    evaluationResults.addAll(qt.t.apply(mainInstance, ec, qualified));
                }
                boolean bl = fired = evaluationResults.size() > 0;
                if (fired) {
                    this.accessor.getEventNotifier().publishEvent(new Event(qt.t.getClass().getSimpleName(), evaluationResults));
                }
                updatedContextRef.add(contextRef);
            }
            catch (Exception e) {
                throw new RuntimeException("Error evaluating field '" + contextRef.getNameLast() + "': " + e.getMessage(), e);
            }
        }
        return evaluationResults;
    }
}

