/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model;

import java.io.Serializable;
import java.util.ArrayList;
import org.javarosa.core.model.FormDef;
import org.javarosa.core.model.IFormElement;
import org.javarosa.core.model.instance.TreeReference;

public class FormIndex
implements Serializable {
    private boolean beginningOfForm = false;
    private boolean endOfForm = false;
    private int localIndex;
    private int instanceIndex = -1;
    private FormIndex nextLevel;
    private TreeReference reference;

    public static FormIndex createBeginningOfFormIndex() {
        FormIndex begin = new FormIndex(-1, null);
        begin.beginningOfForm = true;
        return begin;
    }

    public static FormIndex createEndOfFormIndex() {
        FormIndex end = new FormIndex(-1, null);
        end.endOfForm = true;
        return end;
    }

    public FormIndex(int localIndex, TreeReference reference) {
        this.localIndex = localIndex;
        this.reference = reference;
    }

    public FormIndex(int localIndex, int instanceIndex, TreeReference reference) {
        this.localIndex = localIndex;
        this.instanceIndex = instanceIndex;
        this.reference = reference;
    }

    public FormIndex(FormIndex nextLevel, int localIndex, TreeReference reference) {
        this(localIndex, reference);
        this.nextLevel = nextLevel;
    }

    public FormIndex(FormIndex nextLevel, FormIndex currentLevel) {
        if (currentLevel == null) {
            this.nextLevel = nextLevel.nextLevel;
            this.localIndex = nextLevel.localIndex;
            this.instanceIndex = nextLevel.instanceIndex;
            this.reference = nextLevel.reference;
        } else {
            this.nextLevel = nextLevel;
            this.localIndex = currentLevel.getLocalIndex();
            this.instanceIndex = currentLevel.getInstanceIndex();
            this.reference = currentLevel.reference;
        }
    }

    public FormIndex(FormIndex nextLevel, int localIndex, int instanceIndex, TreeReference reference) {
        this(nextLevel, localIndex, reference);
        this.instanceIndex = instanceIndex;
    }

    public boolean isInForm() {
        return !this.beginningOfForm && !this.endOfForm;
    }

    public int getLocalIndex() {
        return this.localIndex;
    }

    public int getInstanceIndex() {
        return this.instanceIndex;
    }

    public int getElementMultiplicity() {
        return this.getTerminal().instanceIndex;
    }

    public FormIndex getNextLevel() {
        return this.nextLevel;
    }

    public TreeReference getLocalReference() {
        return this.reference;
    }

    public TreeReference getReference() {
        return this.getTerminal().reference;
    }

    public FormIndex getTerminal() {
        FormIndex walker = this;
        while (walker.nextLevel != null) {
            walker = walker.nextLevel;
        }
        return walker;
    }

    public boolean isTerminal() {
        return this.nextLevel == null;
    }

    public boolean isEndOfFormIndex() {
        return this.endOfForm;
    }

    public boolean isBeginningOfFormIndex() {
        return this.beginningOfForm;
    }

    public boolean equals(Object o) {
        if (!(o instanceof FormIndex)) {
            return false;
        }
        FormIndex a = this;
        FormIndex b = (FormIndex)o;
        return a.compareTo(b) == 0;
    }

    public int compareTo(Object o) {
        if (!(o instanceof FormIndex)) {
            throw new IllegalArgumentException("Attempt to compare Object of type " + o.getClass().getName() + " to a FormIndex");
        }
        FormIndex a = this;
        FormIndex b = (FormIndex)o;
        if (a.beginningOfForm) {
            return b.beginningOfForm ? 0 : -1;
        }
        if (a.endOfForm) {
            return b.endOfForm ? 0 : 1;
        }
        if (b.beginningOfForm) {
            return 1;
        }
        if (b.endOfForm) {
            return -1;
        }
        if (a.localIndex != b.localIndex) {
            return a.localIndex < b.localIndex ? -1 : 1;
        }
        if (a.instanceIndex != b.instanceIndex) {
            return a.instanceIndex < b.instanceIndex ? -1 : 1;
        }
        if (a.getNextLevel() == null != (b.getNextLevel() == null)) {
            return a.getNextLevel() == null ? -1 : 1;
        }
        if (a.getNextLevel() != null) {
            return a.getNextLevel().compareTo(b.getNextLevel());
        }
        return 0;
    }

    public FormIndex snip() {
        FormIndex retval = new FormIndex(this.localIndex, this.instanceIndex, this.reference);
        return retval;
    }

    public FormIndex diff(FormIndex subIndex) {
        if (subIndex == null) {
            return this;
        }
        if (!FormIndex.isSubIndex(this, subIndex)) {
            return null;
        }
        if (subIndex.equals(this)) {
            return null;
        }
        return new FormIndex(this.nextLevel.diff(subIndex), this.snip());
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        FormIndex ref = this;
        while (ref != null) {
            b.append(ref.getLocalIndex());
            if (ref.getInstanceIndex() != -1) {
                b.append("_").append(ref.getInstanceIndex());
            }
            b.append(", ");
            ref = ref.nextLevel;
        }
        return b.toString();
    }

    public int getDepth() {
        int depth = 0;
        FormIndex ref = this;
        while (ref != null) {
            ref = ref.nextLevel;
            ++depth;
        }
        return depth;
    }

    public static FormIndex trimNegativeIndices(FormIndex index) {
        if (!index.isTerminal()) {
            return new FormIndex(FormIndex.trimNegativeIndices(index.nextLevel), index);
        }
        if (index.getLocalIndex() < 0) {
            return null;
        }
        return index;
    }

    public static boolean isSubIndex(FormIndex parent, FormIndex child) {
        if (child.equals(parent)) {
            return true;
        }
        if (parent == null) {
            return false;
        }
        return FormIndex.isSubIndex(parent.nextLevel, child);
    }

    public static boolean isSubElement(FormIndex parent, FormIndex child) {
        while (!parent.isTerminal() && !child.isTerminal()) {
            if (parent.getLocalIndex() != child.getLocalIndex()) {
                return false;
            }
            if (parent.getInstanceIndex() != child.getInstanceIndex()) {
                return false;
            }
            parent = parent.nextLevel;
            child = child.nextLevel;
        }
        if (!parent.isTerminal() && child.isTerminal()) {
            return false;
        }
        if (parent.getLocalIndex() != child.getLocalIndex()) {
            return false;
        }
        return parent.getInstanceIndex() == -1 || parent.getInstanceIndex() == child.getInstanceIndex();
    }

    public void assignRefs(FormDef f) {
        FormIndex cur = this;
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        ArrayList<Integer> multiplicities = new ArrayList<Integer>();
        ArrayList<IFormElement> elements = new ArrayList<IFormElement>();
        f.collapseIndex(this, indexes, multiplicities, elements);
        ArrayList<Integer> curMults = new ArrayList<Integer>();
        ArrayList<IFormElement> curElems = new ArrayList<IFormElement>();
        int i = 0;
        while (cur != null) {
            TreeReference ref;
            curMults.add((Integer)multiplicities.get(i));
            curElems.add((IFormElement)elements.get(i));
            cur.reference = ref = f.getChildInstanceRef(curElems, curMults);
            cur = cur.getNextLevel();
            ++i;
        }
    }
}

