/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.services.storage;

import java.util.List;
import java.util.NoSuchElementException;
import org.javarosa.core.services.storage.EntityFilter;
import org.javarosa.core.services.storage.FauxIndexedPersistable;
import org.javarosa.core.services.storage.IMetaData;
import org.javarosa.core.services.storage.IStorageFactory;
import org.javarosa.core.services.storage.IStorageIterator;
import org.javarosa.core.services.storage.IStorageUtility;
import org.javarosa.core.services.storage.IStorageUtilityIndexed;
import org.javarosa.core.services.storage.Persistable;
import org.javarosa.core.services.storage.StorageFullException;
import org.javarosa.core.util.InvalidIndexException;
import org.javarosa.core.util.externalizable.Externalizable;

public class WrappingStorageUtility
implements IStorageUtilityIndexed {
    IStorageUtility storage;
    SerializationWrapper wrapper;

    public WrappingStorageUtility(String name, SerializationWrapper wrapper, IStorageFactory storageFactory) {
        this.storage = storageFactory.newStorage(name, wrapper.getClass());
        this.wrapper = wrapper;
    }

    @Override
    public Externalizable read(int id) {
        return ((SerializationWrapper)this.storage.read(id)).getData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Persistable p) throws StorageFullException {
        SerializationWrapper serializationWrapper = this.wrapper;
        synchronized (serializationWrapper) {
            this.wrapper.setData(p);
            if (this.wrapper instanceof IMetaData) {
                this.storage.write(new FauxIndexedPersistable(p, this.wrapper, (IMetaData)((Object)this.wrapper)));
            } else {
                this.storage.write(new FauxIndexedPersistable(p, this.wrapper));
            }
            this.wrapper.clean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int add(Externalizable e) throws StorageFullException {
        SerializationWrapper serializationWrapper = this.wrapper;
        synchronized (serializationWrapper) {
            this.wrapper.setData(e);
            int result = this.storage.add(this.wrapper);
            this.wrapper.clean();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(int id, Externalizable e) throws StorageFullException {
        SerializationWrapper serializationWrapper = this.wrapper;
        synchronized (serializationWrapper) {
            this.wrapper.setData(e);
            this.storage.update(id, this.wrapper);
            this.wrapper.clean();
        }
    }

    @Override
    public IStorageIterator iterate() {
        return new IStorageIterator(){
            IStorageIterator baseIterator;
            {
                this.baseIterator = WrappingStorageUtility.this.storage.iterate();
            }

            @Override
            public boolean hasMore() {
                return this.baseIterator.hasMore();
            }

            @Override
            public int nextID() {
                return this.baseIterator.nextID();
            }

            @Override
            public Externalizable nextRecord() {
                return ((SerializationWrapper)this.baseIterator.nextRecord()).getData();
            }

            @Override
            public int numRecords() {
                return this.baseIterator.numRecords();
            }

            @Override
            public int peekID() {
                return this.baseIterator.peekID();
            }
        };
    }

    @Override
    public byte[] readBytes(int id) {
        return this.storage.readBytes(id);
    }

    @Override
    public void remove(int id) {
        this.storage.remove(id);
    }

    @Override
    public void remove(Persistable p) {
        this.storage.remove(p);
    }

    @Override
    public void removeAll() {
        this.storage.removeAll();
    }

    @Override
    public List<Integer> removeAll(EntityFilter ef) {
        return this.storage.removeAll(ef);
    }

    @Override
    public boolean exists(int id) {
        return this.storage.exists(id);
    }

    @Override
    public boolean isEmpty() {
        return this.storage.isEmpty();
    }

    @Override
    public int getNumRecords() {
        return this.storage.getNumRecords();
    }

    @Override
    public int getRecordSize(int id) {
        return this.storage.getRecordSize(id);
    }

    @Override
    public int getTotalSize() {
        return this.storage.getTotalSize();
    }

    @Override
    public void close() {
        this.storage.close();
    }

    @Override
    public void destroy() {
        this.storage.destroy();
    }

    @Override
    public void repack() {
        this.storage.repack();
    }

    @Override
    public void repair() {
        this.storage.repair();
    }

    @Override
    public Object getAccessLock() {
        return this.storage.getAccessLock();
    }

    @Override
    public List<Integer> getIDsForValue(String fieldName, Object value) {
        return this.indexedStorage().getIDsForValue(fieldName, value);
    }

    public Externalizable getRecordForValue(String fieldName, Object value) throws NoSuchElementException, InvalidIndexException {
        return ((SerializationWrapper)this.indexedStorage().getRecordForValue(fieldName, value)).getData();
    }

    private IStorageUtilityIndexed indexedStorage() {
        if (!(this.storage instanceof IStorageUtilityIndexed)) {
            throw new RuntimeException("WrappingStorageUtility's factory is not of an indexed type, but had indexed operations requested. Please implement storage " + this.storage.getClass().getName() + " as indexed storage");
        }
        return (IStorageUtilityIndexed)this.storage;
    }

    @Override
    public void setReadOnly() {
        this.storage.setReadOnly();
    }

    @Override
    public void registerIndex(String filterIndex) {
        this.indexedStorage().registerIndex(filterIndex);
    }

    public static interface SerializationWrapper
    extends Externalizable {
        public void setData(Externalizable var1);

        public Externalizable getData();

        public Class baseType();

        public void clean();
    }
}

