/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.data;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.javarosa.core.model.data.GeoPointData;
import org.javarosa.core.model.data.IAnswerData;
import org.javarosa.core.model.data.UncastData;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.javarosa.xpath.IExprDataType;

public class GeoShapeData
implements IAnswerData,
IExprDataType {
    public final ArrayList<GeoPointData> points = new ArrayList();

    public GeoShapeData() {
    }

    public GeoShapeData(GeoShapeData data) {
        for (GeoPointData p : data.points) {
            this.points.add(new GeoPointData(p));
        }
    }

    public GeoShapeData(GeoShape ashape) {
        for (double[] da : ashape.points) {
            this.points.add(new GeoPointData(da));
        }
    }

    @Override
    public IAnswerData clone() {
        return new GeoShapeData(this);
    }

    @Override
    public String getDisplayText() {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (GeoPointData p : this.points) {
            if (!first) {
                b.append("; ");
            }
            first = false;
            b.append(p.getDisplayText());
        }
        return b.toString();
    }

    @Override
    public Object getValue() {
        ArrayList<double[]> pts = new ArrayList<double[]>();
        for (GeoPointData p : this.points) {
            pts.add((double[])p.getValue());
        }
        GeoShape gs = new GeoShape(pts);
        return gs;
    }

    @Override
    public void setValue(Object o) {
        if (o == null) {
            throw new NullPointerException("Attempt to set an IAnswerData class to null.");
        }
        if (!(o instanceof GeoShape)) {
            GeoShapeData t = new GeoShapeData();
            GeoShapeData v = t.cast(new UncastData(o.toString()));
            o = v.getValue();
        }
        GeoShape gs = (GeoShape)o;
        ArrayList<GeoPointData> temp = new ArrayList<GeoPointData>();
        for (double[] da : gs.points) {
            temp.add(new GeoPointData(da));
        }
        this.points.clear();
        this.points.addAll(temp);
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
        this.points.clear();
        int len = (int)ExtUtil.readNumeric(in);
        for (int i = 0; i < len; ++i) {
            GeoPointData t = new GeoPointData();
            t.readExternal(in, pf);
            this.points.add(t);
        }
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        ExtUtil.writeNumeric(out, this.points.size());
        for (int i = 0; i < this.points.size(); ++i) {
            GeoPointData t = this.points.get(i);
            t.writeExternal(out);
        }
    }

    @Override
    public UncastData uncast() {
        return new UncastData(this.getDisplayText());
    }

    @Override
    public GeoShapeData cast(UncastData data) throws IllegalArgumentException {
        String[] parts = data.value.split(";");
        GeoPointData t = new GeoPointData();
        GeoShapeData d = new GeoShapeData();
        for (String part : parts) {
            d.points.add(t.cast(new UncastData(part.trim())));
        }
        return d;
    }

    @Override
    public Boolean toBoolean() {
        if (this.points.size() == 0) {
            return false;
        }
        return true;
    }

    @Override
    public Double toNumeric() {
        if (this.points.size() == 0) {
            return 9999999.0;
        }
        double maxValue = 0.0;
        for (GeoPointData p : this.points) {
            maxValue = Math.max(maxValue, p.toNumeric());
        }
        return maxValue;
    }

    @Override
    public String toString() {
        return this.getDisplayText();
    }

    public static class GeoShape {
        public ArrayList<double[]> points;

        public GeoShape() {
            this.points = new ArrayList();
        }

        public GeoShape(ArrayList<double[]> points) {
            this.points = points;
        }
    }
}

