/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.condition;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.javarosa.core.model.condition.IFunctionHandler;
import org.javarosa.core.model.data.IAnswerData;
import org.javarosa.core.model.instance.AbstractTreeElement;
import org.javarosa.core.model.instance.DataInstance;
import org.javarosa.core.model.instance.TreeElement;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.xpath.IExprDataType;
import org.javarosa.xpath.expr.XPathExpression;

public class EvaluationContext {
    private TreeReference contextNode;
    private HashMap<String, IFunctionHandler> functionHandlers;
    private HashMap<String, Object> variables;
    public boolean isConstraint;
    public IAnswerData candidateValue;
    public boolean isCheckAddChild;
    private String outputTextForm = null;
    private HashMap<String, DataInstance> formInstances;
    private TreeReference original;
    private int currentContextPosition = -1;
    private DataInstance instance;
    private int[] predicateEvaluationProgress;

    private EvaluationContext(EvaluationContext base) {
        this.functionHandlers = base.functionHandlers;
        this.formInstances = base.formInstances;
        this.variables = base.variables;
        this.contextNode = base.contextNode;
        this.instance = base.instance;
        this.isConstraint = base.isConstraint;
        this.candidateValue = base.candidateValue;
        this.isCheckAddChild = base.isCheckAddChild;
        this.outputTextForm = base.outputTextForm;
        this.original = base.original;
        this.currentContextPosition = base.currentContextPosition;
    }

    public EvaluationContext(EvaluationContext base, TreeReference context) {
        this(base);
        this.contextNode = context;
    }

    public EvaluationContext(EvaluationContext base, HashMap<String, DataInstance> formInstances, TreeReference context) {
        this(base, context);
        this.formInstances = formInstances;
    }

    public EvaluationContext(DataInstance instance, HashMap<String, DataInstance> formInstances, EvaluationContext base) {
        this(base);
        this.formInstances = formInstances;
        this.instance = instance;
    }

    public EvaluationContext(DataInstance instance) {
        this(instance, new HashMap<String, DataInstance>());
    }

    public EvaluationContext(DataInstance instance, HashMap<String, DataInstance> formInstances) {
        this.formInstances = formInstances;
        this.instance = instance;
        this.contextNode = TreeReference.rootRef();
        this.functionHandlers = new HashMap();
        this.variables = new HashMap();
    }

    public DataInstance getInstance(String id) {
        DataInstance formInstance = this.formInstances.get(id);
        return formInstance != null ? formInstance : (this.instance != null && id.equals(this.instance.getName()) ? this.instance : null);
    }

    public TreeReference getContextRef() {
        return this.contextNode;
    }

    public void setOriginalContext(TreeReference ref) {
        this.original = ref;
    }

    public TreeReference getOriginalContext() {
        return this.original == null ? this.contextNode : this.original;
    }

    public void addFunctionHandler(IFunctionHandler fh) {
        this.functionHandlers.put(fh.getName(), fh);
    }

    public HashMap<String, IFunctionHandler> getFunctionHandlers() {
        return this.functionHandlers;
    }

    public void setOutputTextForm(String form) {
        this.outputTextForm = form;
    }

    public String getOutputTextForm() {
        return this.outputTextForm;
    }

    public void setVariables(HashMap<String, ?> variables) {
        for (String var : variables.keySet()) {
            this.setVariable(var, variables.get(var));
        }
    }

    public void setVariable(String name, Object value) {
        if (value == null) {
            this.variables.put(name, "");
            return;
        }
        if (value instanceof Boolean || value instanceof Double || value instanceof String || value instanceof Date || value instanceof IExprDataType) {
            this.variables.put(name, value);
            return;
        }
        if (value instanceof Integer) {
            this.variables.put(name, ((Integer)value).doubleValue());
        } else if (value instanceof Float) {
            this.variables.put(name, ((Float)value).doubleValue());
        } else {
            this.variables.put(name, value);
        }
    }

    public Object getVariable(String name) {
        return this.variables.get(name);
    }

    public List<TreeReference> expandReference(TreeReference ref) {
        return this.expandReference(ref, false);
    }

    public List<TreeReference> expandReference(TreeReference ref, boolean includeTemplates) {
        DataInstance baseInstance;
        if (!ref.isAbsolute()) {
            return null;
        }
        DataInstance dataInstance = baseInstance = ref.getInstanceName() != null ? this.getInstance(ref.getInstanceName()) : this.instance;
        if (baseInstance == null) {
            throw new RuntimeException("Unable to expand reference " + ref.toString(true) + ", no appropriate instance in evaluation context");
        }
        ArrayList<TreeReference> treeReferences = new ArrayList<TreeReference>(1);
        TreeReference workingRef = baseInstance.getRoot().getRef();
        this.expandReferenceAccumulator(ref, baseInstance, workingRef, treeReferences, includeTemplates);
        return treeReferences;
    }

    private void expandReferenceAccumulator(TreeReference sourceRef, DataInstance sourceInstance, TreeReference workingRef, List<TreeReference> refs, boolean includeTemplates) {
        Object attribute;
        int depth = workingRef.size();
        if (depth == sourceRef.size()) {
            refs.add(workingRef);
            return;
        }
        String name = sourceRef.getName(depth);
        List<XPathExpression> predicates = sourceRef.getPredicate(depth);
        if (predicates != null) {
            ArrayList<XPathExpression> predCopy = new ArrayList<XPathExpression>(predicates.size());
            for (XPathExpression xpe : predicates) {
                predCopy.add(xpe);
            }
            predicates = predCopy;
        }
        int mult = sourceRef.getMultiplicity(depth);
        ArrayList<TreeReference> treeReferences = new ArrayList<TreeReference>(1);
        Object node = sourceInstance.resolveReference(workingRef);
        if (node.getNumChildren() > 0) {
            Object child;
            if (mult == -1) {
                Object template;
                List childrenWithName = node.getChildrenWithName(name);
                int count = childrenWithName.size();
                for (int i = 0; i < count; ++i) {
                    TreeElement child2 = (TreeElement)childrenWithName.get(i);
                    if (child2.getMultiplicity() != i) {
                        throw new IllegalStateException("Unexpected multiplicity mismatch");
                    }
                    treeReferences.add(child2.getRef());
                }
                if (includeTemplates && (template = node.getChild(name, -2)) != null) {
                    treeReferences.add(template.getRef());
                }
            } else if (mult != -4 && (child = node.getChild(name, mult)) != null) {
                treeReferences.add(child.getRef());
            }
        }
        if (mult == -4 && (attribute = node.getAttribute(null, name)) != null) {
            treeReferences.add(attribute.getRef());
        }
        if (predicates != null && this.predicateEvaluationProgress != null) {
            this.predicateEvaluationProgress[1] = this.predicateEvaluationProgress[1] + treeReferences.size();
        }
        if (predicates != null) {
            boolean firstTime = true;
            ArrayList<TreeReference> passed = new ArrayList<TreeReference>(treeReferences.size());
            for (XPathExpression xpe : predicates) {
                for (int i = 0; i < treeReferences.size(); ++i) {
                    boolean testOutcome;
                    TreeReference treeRef = (TreeReference)treeReferences.get(i);
                    EvaluationContext evalContext = this.rescope(treeRef, firstTime ? treeRef.getMultLast() : i);
                    Object o = xpe.eval(sourceInstance, evalContext);
                    if (!(o instanceof Boolean) || !(testOutcome = ((Boolean)o).booleanValue())) continue;
                    passed.add(treeRef);
                }
                firstTime = false;
                treeReferences.clear();
                treeReferences.addAll(passed);
                passed.clear();
                if (this.predicateEvaluationProgress == null) continue;
                this.predicateEvaluationProgress[0] = this.predicateEvaluationProgress[0] + 1;
            }
        }
        for (TreeReference treeRef : treeReferences) {
            this.expandReferenceAccumulator(sourceRef, sourceInstance, treeRef, refs, includeTemplates);
        }
    }

    private EvaluationContext rescope(TreeReference treeRef, int currentContextPosition) {
        EvaluationContext ec = new EvaluationContext(this, treeRef);
        ec.currentContextPosition = currentContextPosition;
        if (this.original != null) {
            ec.setOriginalContext(this.getOriginalContext());
        } else if (TreeReference.rootRef().equals(this.getContextRef())) {
            ec.setOriginalContext(treeRef);
        } else {
            ec.setOriginalContext(this.getContextRef());
        }
        return ec;
    }

    public DataInstance getMainInstance() {
        return this.instance;
    }

    public AbstractTreeElement resolveReference(TreeReference qualifiedRef) {
        DataInstance instance = this.getMainInstance();
        if (qualifiedRef.getInstanceName() != null) {
            instance = this.getInstance(qualifiedRef.getInstanceName());
        }
        return instance.resolveReference(qualifiedRef);
    }

    public int getContextPosition() {
        return this.currentContextPosition;
    }

    public void setPredicateProcessSet(int[] loadingDetails) {
        if (loadingDetails != null && loadingDetails.length == 2) {
            this.predicateEvaluationProgress = loadingDetails;
        }
    }
}

