/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xml.util;

import org.kxml2.io.KXmlParser;

public class InvalidStructureException
extends Exception {
    public InvalidStructureException(String message, KXmlParser parser) {
        super("Invalid XML Structure(" + parser.getPositionDescription() + "): " + message);
    }

    public InvalidStructureException(String message, String file, KXmlParser parser) {
        super("Invalid XML Structure in document " + file + "(" + parser.getPositionDescription() + "): " + message);
    }

    public InvalidStructureException(String message) {
        super(message);
    }

    public static InvalidStructureException readableInvalidStructureException(String message, KXmlParser parser) {
        String humanReadableMessage = message + InvalidStructureException.buildParserMessage(parser);
        return new InvalidStructureException(humanReadableMessage);
    }

    private static String buildParserMessage(KXmlParser parser) {
        String prefix = parser.getPrefix();
        if (prefix != null) {
            return ". Source: <" + prefix + ":" + parser.getName() + "> tag in namespace: " + parser.getNamespace();
        }
        return ". Source: <" + parser.getName() + ">";
    }
}

