/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class MultiInputStream
extends InputStream {
    List<InputStream> streams = new ArrayList<InputStream>(1);
    int currentStream = -1;

    public void addStream(InputStream stream) {
        this.streams.add(stream);
    }

    public boolean prepare() {
        if (this.streams.size() == 0) {
            return false;
        }
        this.currentStream = 0;
        return true;
    }

    @Override
    public int read() throws IOException {
        if (this.currentStream == -1) {
            throw new IOException("Cannot read from unprepared MultiInputStream!");
        }
        InputStream cur = this.streams.get(this.currentStream);
        int next = cur.read();
        if (next != -1) {
            return next;
        }
        while (next == -1 && this.currentStream + 1 < this.streams.size()) {
            ++this.currentStream;
            cur = this.streams.get(this.currentStream);
            next = cur.read();
        }
        return next;
    }

    @Override
    public int available() throws IOException {
        if (this.currentStream == -1) {
            throw new IOException("Cannot read from unprepared MultiInputStream!");
        }
        return this.streams.get(this.currentStream).available();
    }

    @Override
    public void close() throws IOException {
        if (this.currentStream == -1) {
            throw new IOException("Cannot read from unprepared MultiInputStream!");
        }
        for (InputStream stream : this.streams) {
            stream.close();
        }
    }
}

