/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.instance;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.javarosa.core.model.instance.AbstractTreeElement;
import org.javarosa.core.model.instance.DataInstance;
import org.javarosa.core.model.instance.InstanceInitializationFactory;
import org.javarosa.core.model.instance.TreeElement;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.javarosa.xml.ElementParser;
import org.javarosa.xml.TreeElementParser;
import org.javarosa.xml.util.InvalidStructureException;
import org.javarosa.xml.util.UnfullfilledRequirementsException;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public class ExternalDataInstance
extends DataInstance {
    private String path;
    private TreeElement root;

    public ExternalDataInstance() {
    }

    public ExternalDataInstance(String path, String instanceId, TreeElement root) {
        super(instanceId);
        this.path = path;
        this.setName(instanceId);
        this.root = root;
    }

    public static ExternalDataInstance buildFromPath(String path, String instanceId) throws IOException, UnfullfilledRequirementsException, XmlPullParserException, InvalidStructureException {
        String absolutePath = ExternalDataInstance.getPathPrefix() + path;
        KXmlParser xmlParser = ElementParser.instantiateParser(new FileInputStream(absolutePath));
        TreeElementParser treeElementParser = new TreeElementParser(xmlParser, 0, instanceId);
        TreeElement root = treeElementParser.parse();
        return new ExternalDataInstance(path, instanceId, root);
    }

    private static String getPathPrefix() {
        return System.getProperty("user.dir") + "/resources";
    }

    public AbstractTreeElement getBase() {
        return this.root;
    }

    public AbstractTreeElement getRoot() {
        return this.root;
    }

    @Override
    public void initialize(InstanceInitializationFactory initializer, String instanceId) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
        super.readExternal(in, pf);
        this.path = ExtUtil.readString(in);
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        super.writeExternal(out);
        ExtUtil.write(out, this.path);
    }

    public static String getPathIfExternalDataInstance(String srcLocation) {
        if (srcLocation != null && !srcLocation.isEmpty()) {
            try {
                URI uri = new URI(srcLocation);
                if ("jr".equals(uri.getScheme()) && "file".equals(uri.getHost())) {
                    return uri.getPath();
                }
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

