/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.data;

import org.javarosa.core.model.DataType;
import org.javarosa.core.model.data.BooleanData;
import org.javarosa.core.model.data.DateData;
import org.javarosa.core.model.data.DateTimeData;
import org.javarosa.core.model.data.DecimalData;
import org.javarosa.core.model.data.GeoPointData;
import org.javarosa.core.model.data.GeoShapeData;
import org.javarosa.core.model.data.GeoTraceData;
import org.javarosa.core.model.data.IAnswerData;
import org.javarosa.core.model.data.IntegerData;
import org.javarosa.core.model.data.LongData;
import org.javarosa.core.model.data.MultipleItemsData;
import org.javarosa.core.model.data.SelectOneData;
import org.javarosa.core.model.data.StringData;
import org.javarosa.core.model.data.TimeData;
import org.javarosa.core.model.data.UncastData;

public class AnswerDataFactory {
    public static IAnswerData template(int controlType, int datatype) {
        if (controlType == 2) {
            return new SelectOneData();
        }
        if (controlType == 3 || controlType == 16) {
            return new MultipleItemsData();
        }
        return AnswerDataFactory.templateByDataType(datatype);
    }

    public static IAnswerData templateByDataType(int datatype) {
        switch (DataType.from(datatype)) {
            case CHOICE: {
                return new SelectOneData();
            }
            case MULTIPLE_ITEMS: {
                return new MultipleItemsData();
            }
            case BOOLEAN: {
                return new BooleanData();
            }
            case DATE: {
                return new DateData();
            }
            case DATE_TIME: {
                return new DateTimeData();
            }
            case DECIMAL: {
                return new DecimalData();
            }
            case GEOPOINT: {
                return new GeoPointData();
            }
            case GEOSHAPE: {
                return new GeoShapeData();
            }
            case GEOTRACE: {
                return new GeoTraceData();
            }
            case INTEGER: {
                return new IntegerData();
            }
            case LONG: {
                return new LongData();
            }
            case TEXT: {
                return new StringData();
            }
            case TIME: {
                return new TimeData();
            }
            case BARCODE: 
            case BINARY: 
            case UNSUPPORTED: 
            case NULL: {
                return new UncastData();
            }
        }
        return new UncastData();
    }
}

