/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.condition.pivot;

import java.util.ArrayList;
import java.util.List;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.condition.IConditionExpr;
import org.javarosa.core.model.condition.pivot.CmpPivot;
import org.javarosa.core.model.condition.pivot.ConstraintHint;
import org.javarosa.core.model.condition.pivot.UnpivotableExpressionException;
import org.javarosa.core.model.data.IAnswerData;
import org.javarosa.core.model.instance.FormInstance;
import org.javarosa.xpath.expr.XPathFuncExpr;

public abstract class RangeHint<T extends IAnswerData>
implements ConstraintHint {
    Double min;
    Double max;
    T minCast;
    T maxCast;
    boolean minInclusive;
    boolean maxInclusive;

    @Override
    public void init(EvaluationContext c, IConditionExpr conditional, FormInstance instance) throws UnpivotableExpressionException {
        List<Object> pivots = conditional.pivot(instance, c);
        ArrayList<CmpPivot> internalPivots = new ArrayList<CmpPivot>(pivots.size());
        for (Object p : pivots) {
            if (!(p instanceof CmpPivot)) {
                throw new UnpivotableExpressionException();
            }
            internalPivots.add((CmpPivot)p);
        }
        if (internalPivots.size() > 2) {
            throw new UnpivotableExpressionException();
        }
        for (CmpPivot pivot : internalPivots) {
            this.evaluatePivot(pivot, conditional, c, instance);
        }
    }

    public T getMin() {
        return this.min == null ? null : (T)this.minCast;
    }

    public boolean isMinInclusive() {
        return this.minInclusive;
    }

    public T getMax() {
        return this.max == null ? null : (T)this.maxCast;
    }

    public boolean isMaxInclusive() {
        return this.maxInclusive;
    }

    private void evaluatePivot(CmpPivot pivot, IConditionExpr conditional, EvaluationContext c, FormInstance instance) throws UnpivotableExpressionException {
        double unit = this.unit();
        double val = pivot.getVal();
        double lt = val - unit;
        double gt = val + unit;
        c.isConstraint = true;
        c.candidateValue = this.castToValue(val);
        boolean eq = XPathFuncExpr.toBoolean(conditional.eval(instance, c));
        c.candidateValue = this.castToValue(lt);
        boolean ltr = XPathFuncExpr.toBoolean(conditional.eval(instance, c));
        c.candidateValue = this.castToValue(gt);
        boolean gtr = XPathFuncExpr.toBoolean(conditional.eval(instance, c));
        if (ltr && !gtr) {
            this.max = new Double(val);
            this.maxInclusive = eq;
            this.maxCast = this.castToValue(this.max);
        }
        if (!ltr && gtr) {
            this.min = new Double(val);
            this.minInclusive = eq;
            this.minCast = this.castToValue(this.min);
        }
    }

    protected abstract T castToValue(double var1) throws UnpivotableExpressionException;

    protected abstract double unit();
}

