/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.model.xform;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.javarosa.core.model.IDataReference;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.javarosa.xpath.XPathException;
import org.javarosa.xpath.XPathParseTool;
import org.javarosa.xpath.XPathTypeMismatchException;
import org.javarosa.xpath.expr.XPathExpression;
import org.javarosa.xpath.expr.XPathPathExpr;
import org.javarosa.xpath.parser.XPathSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XPathReference
implements IDataReference {
    private static final Logger logger = LoggerFactory.getLogger(XPathReference.class);
    private TreeReference ref;
    private String nodeset;

    public XPathReference() {
    }

    public XPathReference(String nodeset) {
        this.ref = XPathReference.getPathExpr(nodeset).getReference();
        this.nodeset = nodeset;
    }

    public static XPathPathExpr getPathExpr(String nodeset) {
        XPathExpression path;
        boolean validNonPathExpr = false;
        try {
            path = XPathParseTool.parseXPath(nodeset);
            if (!(path instanceof XPathPathExpr)) {
                validNonPathExpr = true;
                throw new XPathSyntaxException();
            }
        }
        catch (XPathSyntaxException xse) {
            if (validNonPathExpr) {
                throw new XPathTypeMismatchException("Expected XPath path, got XPath expression: [" + nodeset + "]," + xse.getMessage());
            }
            logger.error("Error", xse);
            throw new XPathException("Parse error in XPath path: [" + nodeset + "]." + (xse.getMessage() == null ? "" : "\n" + xse.getMessage()));
        }
        return (XPathPathExpr)path;
    }

    public XPathReference(XPathPathExpr path) {
        this.ref = path.getReference();
    }

    public XPathReference(TreeReference ref) {
        this.ref = ref;
    }

    @Override
    public Object getReference() {
        return this.ref;
    }

    @Override
    public void setReference(Object o) {
    }

    public boolean equals(Object o) {
        if (o instanceof XPathReference) {
            return this.ref.equals(((XPathReference)o).ref);
        }
        return false;
    }

    public int hashCode() {
        return this.ref.hashCode();
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
        this.nodeset = ExtUtil.nullIfEmpty(ExtUtil.readString(in));
        this.ref = (TreeReference)ExtUtil.read(in, TreeReference.class, pf);
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        ExtUtil.writeString(out, ExtUtil.emptyIfNull(this.nodeset));
        ExtUtil.write(out, this.ref);
    }
}

