/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xpath.expr;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.javarosa.core.util.CacheTable;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapListPoly;
import org.javarosa.core.util.externalizable.ExtWrapNullable;
import org.javarosa.core.util.externalizable.Externalizable;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.javarosa.xpath.expr.XPathExpression;
import org.javarosa.xpath.expr.XPathQName;

public class XPathStep
implements Externalizable {
    public static final int AXIS_CHILD = 0;
    public static final int AXIS_DESCENDANT = 1;
    public static final int AXIS_PARENT = 2;
    public static final int AXIS_ANCESTOR = 3;
    public static final int AXIS_FOLLOWING_SIBLING = 4;
    public static final int AXIS_PRECEDING_SIBLING = 5;
    public static final int AXIS_FOLLOWING = 6;
    public static final int AXIS_PRECEDING = 7;
    public static final int AXIS_ATTRIBUTE = 8;
    public static final int AXIS_NAMESPACE = 9;
    public static final int AXIS_SELF = 10;
    public static final int AXIS_DESCENDANT_OR_SELF = 11;
    public static final int AXIS_ANCESTOR_OR_SELF = 12;
    public static final int TEST_NAME = 0;
    public static final int TEST_NAME_WILDCARD = 1;
    public static final int TEST_NAMESPACE_WILDCARD = 2;
    public static final int TEST_TYPE_NODE = 3;
    public static final int TEST_TYPE_TEXT = 4;
    public static final int TEST_TYPE_COMMENT = 5;
    public static final int TEST_TYPE_PROCESSING_INSTRUCTION = 6;
    private static CacheTable<XPathStep> refs;
    public int axis;
    public int test;
    public XPathExpression[] predicates;
    public XPathQName name;
    public String namespace;
    public String literal;
    public static boolean XPathStepInterningEnabled;

    public static void attachCacheTable(CacheTable<XPathStep> refs) {
        XPathStep.refs = refs;
    }

    public static XPathStep ABBR_SELF() {
        return new XPathStep(10, 3);
    }

    public static XPathStep ABBR_PARENT() {
        return new XPathStep(2, 3);
    }

    public static XPathStep ABBR_DESCENDANTS() {
        return new XPathStep(11, 3);
    }

    public XPathStep() {
    }

    public XPathStep(int axis, int test) {
        this.axis = axis;
        this.test = test;
        this.predicates = new XPathExpression[0];
    }

    public XPathStep(int axis, XPathQName name) {
        this(axis, 0);
        this.name = name;
    }

    public XPathStep(int axis, String namespace) {
        this(axis, 2);
        this.namespace = namespace;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{step:");
        sb.append(XPathStep.axisStr(this.axis));
        sb.append(",");
        sb.append(this.testStr());
        if (this.predicates.length > 0) {
            sb.append(",{");
            for (int i = 0; i < this.predicates.length; ++i) {
                sb.append(this.predicates[i].toString());
                if (i >= this.predicates.length - 1) continue;
                sb.append(",");
            }
            sb.append("}");
        }
        sb.append("}");
        return sb.toString();
    }

    public static String axisStr(int axis) {
        switch (axis) {
            case 0: {
                return "child";
            }
            case 1: {
                return "descendant";
            }
            case 2: {
                return "parent";
            }
            case 3: {
                return "ancestor";
            }
            case 4: {
                return "following-sibling";
            }
            case 5: {
                return "preceding-sibling";
            }
            case 6: {
                return "following";
            }
            case 7: {
                return "preceding";
            }
            case 8: {
                return "attribute";
            }
            case 9: {
                return "namespace";
            }
            case 10: {
                return "self";
            }
            case 11: {
                return "descendant-or-self";
            }
            case 12: {
                return "ancestor-or-self";
            }
        }
        return null;
    }

    public String testStr() {
        switch (this.test) {
            case 0: {
                return this.name.toString();
            }
            case 1: {
                return "*";
            }
            case 2: {
                return this.namespace + ":*";
            }
            case 3: {
                return "node()";
            }
            case 4: {
                return "text()";
            }
            case 5: {
                return "comment()";
            }
            case 6: {
                return "proc-instr(" + (this.literal == null ? "" : "'" + this.literal + "'") + ")";
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o instanceof XPathStep) {
            XPathStep x = (XPathStep)o;
            if (this.axis != x.axis || this.test != x.test || this.predicates.length != x.predicates.length) {
                return false;
            }
            switch (this.test) {
                case 0: {
                    if (this.name.equals(x.name)) break;
                    return false;
                }
                case 2: {
                    if (this.namespace.equals(x.namespace)) break;
                    return false;
                }
                case 6: {
                    if (ExtUtil.equals(this.literal, x.literal)) break;
                    return false;
                }
            }
            return ExtUtil.arrayEquals(this.predicates, x.predicates);
        }
        return false;
    }

    protected boolean matches(XPathStep o) {
        if (o instanceof XPathStep) {
            XPathStep x = o;
            if (this.axis != x.axis || this.test != x.test && (x.test != 0 || this.test != 1) && (this.test != 0 || x.test != 1) || this.predicates.length != x.predicates.length) {
                return false;
            }
            switch (this.test) {
                case 0: {
                    if (x.test == 1 || this.name.equals(x.name)) break;
                    return false;
                }
                case 2: {
                    if (this.namespace.equals(x.namespace)) break;
                    return false;
                }
                case 6: {
                    if (ExtUtil.equals(this.literal, x.literal)) break;
                    return false;
                }
            }
            return ExtUtil.arrayEquals(this.predicates, x.predicates);
        }
        return false;
    }

    public int hashCode() {
        int code = this.axis ^ this.test ^ (this.name == null ? 0 : this.name.hashCode()) ^ (this.literal == null ? 0 : this.literal.hashCode()) ^ (this.namespace == null ? 0 : this.namespace.hashCode());
        for (XPathExpression xpe : this.predicates) {
            code ^= xpe.hashCode();
        }
        return code;
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
        this.axis = ExtUtil.readInt(in);
        this.test = ExtUtil.readInt(in);
        switch (this.test) {
            case 0: {
                this.name = (XPathQName)ExtUtil.read(in, XPathQName.class);
                break;
            }
            case 2: {
                this.namespace = ExtUtil.readString(in);
                break;
            }
            case 6: {
                this.literal = (String)ExtUtil.read(in, new ExtWrapNullable(String.class));
            }
        }
        List v = (List)ExtUtil.read(in, new ExtWrapListPoly(), pf);
        this.predicates = new XPathExpression[v.size()];
        for (int i = 0; i < this.predicates.length; ++i) {
            this.predicates[i] = (XPathExpression)v.get(i);
        }
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        ExtUtil.writeNumeric(out, this.axis);
        ExtUtil.writeNumeric(out, this.test);
        switch (this.test) {
            case 0: {
                ExtUtil.write(out, this.name);
                break;
            }
            case 2: {
                ExtUtil.writeString(out, this.namespace);
                break;
            }
            case 6: {
                ExtUtil.write(out, new ExtWrapNullable(this.literal));
            }
        }
        List<XPathExpression> v = Arrays.asList(this.predicates);
        ExtUtil.write(out, new ExtWrapListPoly(v));
    }

    public XPathStep intern() {
        if (!XPathStepInterningEnabled || refs == null) {
            return this;
        }
        return refs.intern(this);
    }

    static {
        XPathStepInterningEnabled = true;
    }
}

