/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xpath.expr;

import java.io.UnsupportedEncodingException;
import org.javarosa.xpath.XPathUnsupportedException;

enum Encoding {
    HEX("hex"){

        @Override
        String encode(byte[] bytes) {
            StringBuilder sb = new StringBuilder(bytes.length * 2);
            for (byte b : bytes) {
                sb.append(HEX_TBL[b >> 4 & 0xF]);
                sb.append(HEX_TBL[b & 0xF]);
            }
            return sb.toString();
        }
    }
    ,
    BASE64("base64"){

        @Override
        String encode(byte[] sArr) {
            int sLen = sArr.length;
            int sOff = 0;
            if (sLen == 0) {
                return "";
            }
            int eLen = sLen / 3 * 3;
            int dLen = (sLen - 1) / 3 + 1 << 2;
            byte[] dArr = new byte[dLen];
            int s = sOff;
            int d = 0;
            while (s < sOff + eLen) {
                int i = (sArr[s++] & 0xFF) << 16 | (sArr[s++] & 0xFF) << 8 | sArr[s++] & 0xFF;
                dArr[d++] = (byte)BASE_64_TBL[i >>> 18 & 0x3F];
                dArr[d++] = (byte)BASE_64_TBL[i >>> 12 & 0x3F];
                dArr[d++] = (byte)BASE_64_TBL[i >>> 6 & 0x3F];
                dArr[d++] = (byte)BASE_64_TBL[i & 0x3F];
            }
            int left = sLen - eLen;
            if (left > 0) {
                int i = (sArr[sOff + eLen] & 0xFF) << 10 | (left == 2 ? (sArr[sOff + sLen - 1] & 0xFF) << 2 : 0);
                dArr[dLen - 4] = (byte)BASE_64_TBL[i >> 12];
                dArr[dLen - 3] = (byte)BASE_64_TBL[i >>> 6 & 0x3F];
                dArr[dLen - 2] = left == 2 ? (int)BASE_64_TBL[i & 0x3F] : 61;
                dArr[dLen - 1] = 61;
            }
            try {
                return new String(dArr, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Encoding to base64 failed to use UTF-8");
            }
        }
    };

    private final String name;
    private static final char[] HEX_TBL;
    private static final char[] BASE_64_TBL;

    private Encoding(String name) {
        this.name = name;
    }

    static Encoding from(String name) {
        try {
            return Encoding.valueOf(name.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            throw new XPathUnsupportedException("digest(..., ..., '" + name + "')");
        }
    }

    abstract String encode(byte[] var1);

    static {
        HEX_TBL = "0123456789abcdef".toCharArray();
        BASE_64_TBL = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
    }
}

