/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.instance;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import org.javarosa.core.model.FormDef;
import org.javarosa.core.model.data.IAnswerData;
import org.javarosa.core.model.instance.DataInstance;
import org.javarosa.core.model.instance.InstanceInitializationFactory;
import org.javarosa.core.model.instance.InvalidReferenceException;
import org.javarosa.core.model.instance.TreeElement;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.core.model.instance.utils.ITreeVisitor;
import org.javarosa.core.model.utils.IInstanceVisitor;
import org.javarosa.core.services.storage.IMetaData;
import org.javarosa.core.services.storage.Persistable;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapMap;
import org.javarosa.core.util.externalizable.ExtWrapNullable;
import org.javarosa.core.util.externalizable.PrototypeFactory;

public class FormInstance
extends DataInstance<TreeElement>
implements Persistable,
IMetaData {
    public static final String STORAGE_KEY = "FORMDATA";
    private Date dateSaved;
    public String schema;
    public String formVersion;
    public String uiVersion;
    private HashMap<String, Object> namespaces = new HashMap();
    protected TreeElement root = new TreeElement();
    public static final String META_XMLNS = "XMLNS";
    public static final String META_ID = "instance_id";

    public FormInstance() {
    }

    public FormInstance(TreeElement root) {
        this(root, null);
    }

    public FormInstance(TreeElement root, String id) {
        super(id);
        this.setID(-1);
        this.setFormId(-1);
        this.setRoot(root);
    }

    public TreeElement getBase() {
        return this.root;
    }

    @Override
    public TreeElement getRoot() {
        if (this.root.getNumChildren() == 0) {
            throw new RuntimeException("root node has no children");
        }
        return this.root.getChildAt(0);
    }

    public void setRoot(TreeElement topLevel) {
        this.root = new TreeElement();
        if (this.getName() != null) {
            this.root.setInstanceName(this.getName());
        }
        if (topLevel != null) {
            this.root.addChild(topLevel);
        }
    }

    public TreeReference copyNode(TreeReference from, TreeReference to) throws InvalidReferenceException {
        if (!from.isAbsolute()) {
            throw new InvalidReferenceException("Source reference must be absolute for copying", from);
        }
        TreeElement src = (TreeElement)this.resolveReference(from);
        if (src == null) {
            throw new InvalidReferenceException("Null Source reference while attempting to copy node", from);
        }
        return this.copyNode(src, to).getRef();
    }

    public TreeElement copyNode(TreeElement src, TreeReference to) throws InvalidReferenceException {
        if (!to.isAbsolute()) {
            throw new InvalidReferenceException("Destination reference must be absolute for copying", to);
        }
        String dstName = to.getNameLast();
        int dstMult = to.getMultLast();
        TreeReference toParent = to.getParentRef();
        TreeElement parent = (TreeElement)this.resolveReference(toParent);
        if (parent == null) {
            throw new InvalidReferenceException("Null parent reference whle attempting to copy", toParent);
        }
        if (!parent.isChildable()) {
            throw new InvalidReferenceException("Invalid Parent Node: cannot accept children.", toParent);
        }
        if (dstMult == -1) {
            dstMult = parent.getChildMultiplicity(dstName);
        } else if (parent.getChild(dstName, dstMult) != null) {
            throw new InvalidReferenceException("Destination already exists!", to);
        }
        TreeElement dest = src.deepCopy(false);
        dest.setName(dstName);
        dest.setMult(dstMult);
        parent.addChild(dest);
        return dest;
    }

    public Date getDateSaved() {
        return this.dateSaved;
    }

    public TreeReference addNode(TreeReference ambigRef) {
        TreeReference ref = ambigRef.clone();
        if (this.createNode(ref) != null) {
            return ref;
        }
        return null;
    }

    public TreeReference addNode(TreeReference ambigRef, IAnswerData data, int dataType) {
        TreeReference ref = ambigRef.clone();
        TreeElement node = this.createNode(ref);
        if (node != null) {
            if (dataType >= 0) {
                node.setDataType(dataType);
            }
            node.setValue(data);
            return ref;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TreeElement createNode(TreeReference ref) {
        TreeElement node = this.root;
        for (int k = 0; k < ref.size(); ++k) {
            TreeElement child;
            String name = ref.getName(k);
            int count = node.getChildMultiplicity(name);
            int mult = ref.getMultiplicity(k);
            if (k < ref.size() - 1) {
                if (mult == -1) {
                    if (count > 1) {
                        return null;
                    }
                    mult = 0;
                    ref.setMultiplicity(k, 0);
                }
                if ((child = node.getChild(name, mult)) == null) {
                    if (mult != 0) return null;
                    child = new TreeElement(name, count);
                    node.addChild(child);
                    ref.setMultiplicity(k, count);
                }
            } else {
                if (mult != -1 && mult != count) return null;
                if (k == 0 && this.root.getNumChildren() != 0) {
                    return null;
                }
                if (!node.isChildable()) {
                    return null;
                }
                child = new TreeElement(name, count);
                node.addChild(child);
                ref.setMultiplicity(k, count);
            }
            node = child;
        }
        return node;
    }

    public void addNamespace(String prefix, String URI2) {
        this.namespaces.put(prefix, URI2);
    }

    public String[] getNamespacePrefixes() {
        String[] prefixes = new String[this.namespaces.size()];
        int i = 0;
        Iterator<String> iterator = this.namespaces.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            prefixes[i] = key = iterator.next();
            ++i;
        }
        return prefixes;
    }

    public String getNamespaceURI(String prefix) {
        return (String)this.namespaces.get(prefix);
    }

    public TreeElement processSaved(FormInstance template, FormDef f) {
        TreeElement fixedInstanceRoot = template.getRoot().deepCopy(true);
        TreeElement incomingRoot = this.root.getChildAt(0);
        if (!fixedInstanceRoot.getName().equals(incomingRoot.getName()) || incomingRoot.getMult() != 0) {
            throw new RuntimeException("Saved form instance to restore does not match form definition");
        }
        fixedInstanceRoot.populate(incomingRoot, f);
        return fixedInstanceRoot;
    }

    public FormInstance clone() {
        FormInstance cloned = new FormInstance(this.getRoot().deepCopy(true));
        cloned.setID(this.getID());
        cloned.setFormId(this.getFormId());
        cloned.setName(this.getName());
        cloned.setDateSaved(this.getDateSaved());
        cloned.schema = this.schema;
        cloned.formVersion = this.formVersion;
        cloned.uiVersion = this.uiVersion;
        cloned.namespaces = new HashMap();
        for (String key : this.namespaces.keySet()) {
            cloned.namespaces.put(key, this.namespaces.get(key));
        }
        return cloned;
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
        super.readExternal(in, pf);
        this.schema = (String)ExtUtil.read(in, new ExtWrapNullable(String.class), pf);
        this.dateSaved = (Date)ExtUtil.read(in, new ExtWrapNullable(Date.class), pf);
        this.namespaces = (HashMap)ExtUtil.read(in, new ExtWrapMap(String.class, String.class));
        this.setRoot((TreeElement)ExtUtil.read(in, TreeElement.class, pf));
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        super.writeExternal(out);
        ExtUtil.write(out, new ExtWrapNullable(this.schema));
        ExtUtil.write(out, new ExtWrapNullable(this.dateSaved));
        ExtUtil.write(out, new ExtWrapMap(this.namespaces));
        ExtUtil.write(out, this.getRoot());
    }

    public void setDateSaved(Date dateSaved) {
        this.dateSaved = dateSaved;
    }

    public void copyItemsetNode(TreeElement copyNode, TreeReference destRef, FormDef f) throws InvalidReferenceException {
        TreeElement templateNode = (TreeElement)this.getTemplate(destRef);
        TreeElement newNode = this.copyNode(templateNode, destRef);
        newNode.populateTemplate(copyNode, f);
    }

    public void accept(IInstanceVisitor visitor) {
        visitor.visit(this);
        if (visitor instanceof ITreeVisitor) {
            this.root.accept((ITreeVisitor)visitor);
        }
    }

    public static boolean isHomogeneous(TreeElement a, TreeElement b) {
        if (a.isLeaf() && b.isLeaf()) {
            return true;
        }
        if (a.isChildable() && b.isChildable()) {
            for (int k = 0; k < 2; ++k) {
                TreeElement n1 = k == 0 ? a : b;
                TreeElement n2 = k == 0 ? b : a;
                for (int i = 0; i < n1.getNumChildren(); ++i) {
                    TreeElement child1 = n1.getChildAt(i);
                    if (child1.isRepeatable()) continue;
                    TreeElement child2 = n2.getChild(child1.getName(), 0);
                    if (child2 == null) {
                        return false;
                    }
                    if (!child2.isRepeatable()) continue;
                    throw new RuntimeException("shouldn't happen");
                }
            }
            for (int i = 0; i < a.getNumChildren(); ++i) {
                TreeElement childB;
                TreeElement childA = a.getChildAt(i);
                if (childA.isRepeatable() || FormInstance.isHomogeneous(childA, childB = b.getChild(childA.getName(), 0))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void initialize(InstanceInitializationFactory initializer, String instanceId) {
        this.setInstanceId(instanceId);
        this.root.setInstanceName(instanceId);
    }

    @Override
    public String[] getMetaDataFields() {
        return new String[]{META_XMLNS, META_ID};
    }

    @Override
    public HashMap<String, Object> getMetaData() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        for (String key : this.getMetaDataFields()) {
            data.put(key, this.getMetaData(key));
        }
        return data;
    }

    @Override
    public Object getMetaData(String fieldName) {
        if (META_XMLNS.equals(fieldName)) {
            return ExtUtil.emptyIfNull(this.schema);
        }
        if (META_ID.equals(fieldName)) {
            return ExtUtil.emptyIfNull(this.getInstanceId());
        }
        throw new IllegalArgumentException("No metadata field " + fieldName + " in the form instance storage system");
    }
}

