/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.javarosa.core.model.FormDef;
import org.javarosa.core.model.IDag;
import org.javarosa.core.model.LatestDagBase;
import org.javarosa.core.model.QuickTriggerable;
import org.javarosa.core.model.condition.Condition;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.instance.AbstractTreeElement;
import org.javarosa.core.model.instance.FormInstance;
import org.javarosa.core.model.instance.TreeElement;
import org.javarosa.core.model.instance.TreeReference;

public class Fast2014DagImpl
extends LatestDagBase {
    private final FormDef.EvalBehavior mode = FormDef.EvalBehavior.Fast_2014;

    public Fast2014DagImpl(IDag.EventNotifierAccessor accessor) {
        super(accessor);
    }

    @Override
    public FormDef.EvalBehavior getEvalBehavior() {
        return this.mode;
    }

    @Override
    public QuickTriggerable getTriggerableForRepeatGroup(TreeReference repeatRef) {
        return (QuickTriggerable)this.conditionRepeatTargetIndex.get(repeatRef.genericize());
    }

    @Override
    public void deleteRepeatGroup(FormInstance mainInstance, EvaluationContext evalContext, TreeReference deleteRef, TreeElement parentElement, TreeElement deletedElement) {
        Set<QuickTriggerable> alreadyEvaluated = this.triggerTriggerables(mainInstance, evalContext, deleteRef, true, new HashSet<QuickTriggerable>(0));
        this.publishSummary("Deleted", deleteRef, alreadyEvaluated);
        this.evaluateChildrenTriggerables(mainInstance, evalContext, deletedElement, false, true, alreadyEvaluated);
    }

    @Override
    public void createRepeatGroup(FormInstance mainInstance, EvaluationContext evalContext, TreeReference createRef, TreeElement parentElement, TreeElement createdElement) {
        Set<QuickTriggerable> qtSet1 = this.triggerTriggerables(mainInstance, evalContext, createRef, true, new HashSet<QuickTriggerable>(0));
        this.publishSummary("Created (phase 1)", createRef, qtSet1);
        Set<QuickTriggerable> qtSet2 = this.initializeTriggerables(mainInstance, evalContext, createRef, true, new HashSet<QuickTriggerable>(0));
        this.publishSummary("Created (phase 2)", createRef, qtSet2);
        HashSet<QuickTriggerable> alreadyEvaluated = new HashSet<QuickTriggerable>(qtSet1);
        alreadyEvaluated.addAll(qtSet2);
        this.evaluateChildrenTriggerables(mainInstance, evalContext, createdElement, true, true, alreadyEvaluated);
    }

    private void evaluateChildrenTriggerables(FormInstance mainInstance, EvaluationContext evalContext, TreeElement newNode, boolean createdOrDeleted, boolean midSurvey, Set<QuickTriggerable> alreadyEvaluated) {
        int numChildren = newNode.getNumChildren();
        for (int i = 0; i < numChildren; ++i) {
            TreeReference anchorRef = newNode.getChildAt(i).getRef();
            Set<QuickTriggerable> childTriggerables = this.triggerTriggerables(mainInstance, evalContext, anchorRef, midSurvey, alreadyEvaluated);
            this.publishSummary(createdOrDeleted ? "Created" : "Deleted", anchorRef, childTriggerables);
        }
    }

    @Override
    public void copyItemsetAnswer(FormInstance mainInstance, EvaluationContext evalContext, TreeReference copyRef, TreeElement copyToElement, boolean midSurvey) {
        TreeReference targetRef = copyToElement.getRef();
        Set<QuickTriggerable> qtSet1 = this.triggerTriggerables(mainInstance, evalContext, copyRef, midSurvey, new HashSet<QuickTriggerable>(0));
        this.publishSummary("Copied itemset answer (phase 1)", targetRef, qtSet1);
        Set<QuickTriggerable> qtSet2 = this.initializeTriggerables(mainInstance, evalContext, copyRef, midSurvey, new HashSet<QuickTriggerable>(0));
        this.publishSummary("Copied itemset answer (phase 2)", targetRef, qtSet2);
    }

    @Override
    public void finalizeTriggerables(FormInstance mainInstance, EvaluationContext evalContext) throws IllegalStateException {
        Object edge;
        ArrayList vertices = new ArrayList(this.unorderedTriggerables);
        this.triggerablesDAG.clear();
        ArrayList<Object> partialOrdering = new ArrayList<Object>();
        HashSet<QuickTriggerable> deps = new HashSet<QuickTriggerable>();
        HashSet<QuickTriggerable> newDestinationSet = new HashSet<QuickTriggerable>();
        for (QuickTriggerable qt : vertices) {
            deps.clear();
            newDestinationSet.clear();
            this.fillTriggeredElements(mainInstance, evalContext, qt, deps, newDestinationSet, true);
            deps.remove(qt);
            for (QuickTriggerable qu : deps) {
                edge = new QuickTriggerable[]{qt, qu};
                partialOrdering.add(edge);
            }
            qt.t.setImmediateCascades(deps);
        }
        ArrayList orderedRoots = new ArrayList();
        HashSet roots = new HashSet(vertices.size());
        int waveCount = -1;
        while (vertices.size() > 0) {
            int i;
            ++waveCount;
            roots.clear();
            roots.addAll(vertices);
            for (i = 0; i < partialOrdering.size(); ++i) {
                edge = (QuickTriggerable[])partialOrdering.get(i);
                roots.remove(edge[1]);
            }
            if (roots.size() == 0) {
                String hints = "";
                for (QuickTriggerable qt : vertices) {
                    for (TreeReference r : qt.t.getTargets()) {
                        hints = hints + "\n" + r.toString(true);
                    }
                }
                String message = "Cycle detected in form's relevant and calculation logic!";
                if (!hints.equals("")) {
                    message = message + "\nThe following nodes are likely involved in the loop:" + hints;
                }
                throw new IllegalStateException(message);
            }
            orderedRoots.clear();
            orderedRoots.addAll(roots);
            Collections.sort(orderedRoots, QuickTriggerable.quickTriggerablesRootOrdering);
            for (i = 0; i < orderedRoots.size(); ++i) {
                QuickTriggerable root = (QuickTriggerable)orderedRoots.get(i);
                root.t.setWaveCount(waveCount);
                this.triggerablesDAG.add(root);
                vertices.remove(root);
            }
            for (i = partialOrdering.size() - 1; i >= 0; --i) {
                edge = (QuickTriggerable[])partialOrdering.get(i);
                if (!roots.contains(edge[0])) continue;
                partialOrdering.remove(i);
            }
        }
        this.conditionRepeatTargetIndex.clear();
        for (QuickTriggerable qt : this.triggerablesDAG) {
            if (!(qt.t instanceof Condition)) continue;
            List<TreeReference> targets = qt.t.getTargets();
            for (TreeReference target : targets) {
                if (mainInstance.getTemplate(target) == null) continue;
                this.conditionRepeatTargetIndex.put(target, qt);
            }
        }
    }

    public void fillTriggeredElements(FormInstance mainInstance, EvaluationContext evalContext, QuickTriggerable qt, Set<QuickTriggerable> destinationSet, Set<QuickTriggerable> newDestinationSet, boolean midSurvey) {
        block8: {
            if (!qt.t.canCascade()) break block8;
            List<TreeReference> targets = qt.t.getTargets();
            if (!midSurvey) {
                for (TreeReference target : targets) {
                    ArrayList triggered = (ArrayList)this.triggerIndex.get(target);
                    if (triggered == null) continue;
                    for (QuickTriggerable qu : triggered) {
                        if (destinationSet.contains(qu)) continue;
                        destinationSet.add(qu);
                        newDestinationSet.add(qu);
                    }
                }
            } else {
                boolean expandRepeatables = true;
                for (TreeReference target : targets) {
                    HashSet<TreeReference> updatedNodes = new HashSet<TreeReference>();
                    updatedNodes.add(target);
                    if (qt.t.isCascadingToChildren()) {
                        this.addChildrenOfReference(mainInstance, evalContext, target, updatedNodes, expandRepeatables);
                    }
                    for (TreeReference ref : updatedNodes) {
                        ArrayList triggered = (ArrayList)this.triggerIndex.get(ref.hasPredicates() ? ref.removePredicates() : ref);
                        if (triggered == null) continue;
                        for (QuickTriggerable qu : triggered) {
                            if (destinationSet.contains(qu)) continue;
                            destinationSet.add(qu);
                            newDestinationSet.add(qu);
                        }
                    }
                }
            }
        }
    }

    private Set<QuickTriggerable> evaluateTriggerables(FormInstance mainInstance, EvaluationContext evalContext, Set<QuickTriggerable> tv, TreeReference anchorRef, boolean midSurvey, Set<QuickTriggerable> alreadyEvaluated) {
        HashSet<QuickTriggerable> refSet = new HashSet<QuickTriggerable>(tv);
        while (!refSet.isEmpty()) {
            HashSet<QuickTriggerable> newSet = new HashSet<QuickTriggerable>();
            for (QuickTriggerable qt : refSet) {
                this.fillTriggeredElements(mainInstance, evalContext, qt, tv, newSet, midSurvey);
            }
            refSet = newSet;
        }
        return this.doEvaluateTriggerables(mainInstance, evalContext, tv, anchorRef, alreadyEvaluated);
    }

    public void addChildrenOfReference(FormInstance mainInstance, EvaluationContext evalContext, TreeReference original, Set<TreeReference> toAdd, boolean expandRepeatables) {
        TreeElement repeatTemplate;
        TreeElement treeElement = repeatTemplate = expandRepeatables ? (TreeElement)mainInstance.getTemplatePath(original) : null;
        if (repeatTemplate != null) {
            for (int i = 0; i < repeatTemplate.getNumChildren(); ++i) {
                TreeElement child = repeatTemplate.getChildAt(i);
                toAdd.add(child.getRef().genericize());
                this.addChildrenOfElement(mainInstance, evalContext, child, toAdd, expandRepeatables);
            }
        } else {
            List<TreeReference> refSet = evalContext.expandReference(original);
            for (TreeReference ref : refSet) {
                this.addChildrenOfElement(mainInstance, evalContext, evalContext.resolveReference(ref), toAdd, expandRepeatables);
            }
        }
    }

    private void addChildrenOfElement(FormInstance mainInstance, EvaluationContext evalContext, AbstractTreeElement el, Set<TreeReference> toAdd, boolean expandRepeatables) {
        TreeElement repeatTemplate;
        TreeElement treeElement = repeatTemplate = expandRepeatables ? (TreeElement)mainInstance.getTemplatePath(el.getRef()) : null;
        if (repeatTemplate != null) {
            for (int i = 0; i < repeatTemplate.getNumChildren(); ++i) {
                TreeElement child = repeatTemplate.getChildAt(i);
                toAdd.add(child.getRef().genericize());
                this.addChildrenOfElement(mainInstance, evalContext, child, toAdd, expandRepeatables);
            }
        } else {
            for (int i = 0; i < el.getNumChildren(); ++i) {
                Object child = el.getChildAt(i);
                toAdd.add(child.getRef().genericize());
                this.addChildrenOfElement(mainInstance, evalContext, (AbstractTreeElement)child, toAdd, expandRepeatables);
            }
        }
    }

    @Override
    public Collection<QuickTriggerable> initializeTriggerables(FormInstance mainInstance, EvaluationContext evalContext, TreeReference rootRef, boolean midSurvey) {
        return this.initializeTriggerables(mainInstance, evalContext, rootRef, midSurvey, new HashSet<QuickTriggerable>(1));
    }

    private Set<QuickTriggerable> initializeTriggerables(FormInstance mainInstance, EvaluationContext evalContext, TreeReference rootRef, boolean midSurvey, Set<QuickTriggerable> alreadyEvaluated) {
        TreeReference genericRoot = rootRef.genericize();
        HashSet<QuickTriggerable> applicable = new HashSet<QuickTriggerable>();
        block0: for (int i = 0; i < this.triggerablesDAG.size(); ++i) {
            QuickTriggerable qt = (QuickTriggerable)this.triggerablesDAG.get(i);
            for (int j = 0; j < qt.t.getTargets().size(); ++j) {
                TreeReference target = qt.t.getTargets().get(j);
                if (!genericRoot.isParentOf(target, false)) continue;
                applicable.add(qt);
                continue block0;
            }
        }
        return this.evaluateTriggerables(mainInstance, evalContext, applicable, rootRef, midSurvey, alreadyEvaluated);
    }

    @Override
    public Collection<QuickTriggerable> triggerTriggerables(FormInstance mainInstance, EvaluationContext evalContext, TreeReference ref, boolean midSurvey) {
        return this.triggerTriggerables(mainInstance, evalContext, ref, midSurvey, new HashSet<QuickTriggerable>(1));
    }

    private Set<QuickTriggerable> triggerTriggerables(FormInstance mainInstance, EvaluationContext evalContext, TreeReference ref, boolean midSurvey, Set<QuickTriggerable> alreadyEvaluated) {
        TreeReference genericRef = ref.genericize();
        ArrayList triggered = (ArrayList)this.triggerIndex.get(genericRef);
        if (triggered == null) {
            return alreadyEvaluated;
        }
        HashSet<QuickTriggerable> triggeredCopy = new HashSet<QuickTriggerable>(triggered);
        return this.evaluateTriggerables(mainInstance, evalContext, triggeredCopy, ref, midSurvey, alreadyEvaluated);
    }

    @Override
    public boolean shouldTrustPreviouslyCommittedAnswer() {
        return true;
    }
}

