/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.util.externalizable;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapIntEncoding;
import org.javarosa.core.util.externalizable.ExternalizableWrapper;
import org.javarosa.core.util.externalizable.PrototypeFactory;

public class ExtWrapIntEncodingSmall
extends ExtWrapIntEncoding {
    public static final int DEFAULT_BIAS = 1;
    public int bias;

    public ExtWrapIntEncodingSmall(long l) {
        this(l, 1);
    }

    public ExtWrapIntEncodingSmall(long l, int bias) {
        this.val = new Long(l);
        this.bias = bias;
    }

    public ExtWrapIntEncodingSmall() {
        this(null, 1);
    }

    public ExtWrapIntEncodingSmall(Object ignore, int bias) {
        this.bias = bias;
    }

    @Override
    public ExternalizableWrapper clone(Object val) {
        return new ExtWrapIntEncodingSmall(ExtUtil.toLong(val), this.bias);
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException {
        int b = in.readByte();
        long l = b == -1 ? (long)in.readInt() : (long)((b < 0 ? b + 256 : b) - this.bias);
        this.val = new Long(l);
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        int n = ExtUtil.toInt((Long)this.val);
        if (n >= -this.bias && n < 255 - this.bias) {
            out.writeByte((byte)((n += this.bias) >= 128 ? n - 256 : n));
        } else {
            out.writeByte(255);
            out.writeInt(n);
        }
    }

    @Override
    public void metaReadExternal(DataInputStream in, PrototypeFactory pf) throws IOException {
        this.bias = in.readUnsignedByte();
    }

    @Override
    public void metaWriteExternal(DataOutputStream out) throws IOException {
        out.writeByte((byte)this.bias);
    }
}

