/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.services.transport.payload;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.javarosa.core.services.transport.payload.IDataPayload;
import org.javarosa.core.services.transport.payload.IDataPayloadVisitor;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteArrayPayload
implements IDataPayload {
    private static final Logger logger = LoggerFactory.getLogger(ByteArrayPayload.class);
    private byte[] payload;
    private String id;
    private int type;

    public ByteArrayPayload() {
    }

    public ByteArrayPayload(byte[] payload, String id, int type) {
        this.payload = payload;
        this.id = id;
        this.type = type;
    }

    public ByteArrayPayload(byte[] payload) {
        this.payload = payload;
        this.id = null;
        this.type = 1;
    }

    @Override
    public InputStream getPayloadStream() {
        return new ByteArrayInputStream(this.payload);
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
        int length = in.readInt();
        if (length > 0) {
            this.payload = new byte[length];
            in.read(this.payload);
        }
        this.id = ExtUtil.nullIfEmpty(ExtUtil.readString(in));
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        out.writeInt(this.payload.length);
        if (this.payload.length > 0) {
            out.write(this.payload);
        }
        ExtUtil.writeString(out, ExtUtil.emptyIfNull(this.id));
    }

    @Override
    public <T> T accept(IDataPayloadVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public byte[] getPayloadBytes() {
        return this.payload;
    }

    @Override
    public String getPayloadId() {
        return this.id;
    }

    @Override
    public int getPayloadType() {
        return this.type;
    }

    @Override
    public long getLength() {
        return this.payload.length;
    }

    @Override
    public int getTransportId() {
        return -1;
    }

    public String toString() {
        try {
            return new String(this.payload, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error("The encoding being utilized isn't supported.", e);
            return "";
        }
    }
}

