/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xml;

import java.io.IOException;
import java.io.InputStream;
import org.javarosa.xml.util.InvalidStructureException;
import org.javarosa.xml.util.UnfullfilledRequirementsException;
import org.kxml2.io.KXmlParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.XmlPullParserException;

public abstract class ElementParser<T> {
    private static final Logger logger = LoggerFactory.getLogger(ElementParser.class);
    protected final KXmlParser parser;

    ElementParser(KXmlParser parser) {
        this.parser = parser;
    }

    public static KXmlParser instantiateParser(InputStream stream) throws IOException {
        KXmlParser parser = new KXmlParser();
        try {
            parser.setInput(stream, "UTF-8");
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            parser.next();
            return parser;
        }
        catch (XmlPullParserException e) {
            logger.error("Element Parser", e);
            throw new IOException(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
    }

    public abstract T parse() throws InvalidStructureException, IOException, XmlPullParserException, UnfullfilledRequirementsException;

    int nextNonWhitespace() throws XmlPullParserException, IOException {
        int ret = this.parser.next();
        if (ret == 4 && this.parser.isWhitespace()) {
            ret = this.parser.next();
        }
        return ret;
    }
}

