/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.condition;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.javarosa.core.model.QuickTriggerable;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.condition.IConditionExpr;
import org.javarosa.core.model.instance.FormInstance;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapList;
import org.javarosa.core.util.externalizable.ExtWrapTagged;
import org.javarosa.core.util.externalizable.Externalizable;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.javarosa.debug.EvaluationResult;
import org.javarosa.xpath.XPathException;

public abstract class Triggerable
implements Externalizable {
    public static final Comparator<Triggerable> triggerablesRootOrdering = new Comparator<Triggerable>(){

        @Override
        public int compare(Triggerable lhs, Triggerable rhs) {
            int rhsHash;
            int lhsHash;
            int cmp = lhs.contextRef.toString(false).compareTo(rhs.contextRef.toString(false));
            if (cmp != 0) {
                return cmp;
            }
            cmp = lhs.originalContextRef.toString(false).compareTo(rhs.originalContextRef.toString(false));
            if (cmp != 0) {
                return cmp;
            }
            if (lhs.isCascadingToChildren()) {
                if (!rhs.isCascadingToChildren()) {
                    return -1;
                }
            } else if (rhs.isCascadingToChildren()) {
                return 1;
            }
            return (lhsHash = lhs.hashCode()) < (rhsHash = rhs.hashCode()) ? -1 : (lhsHash == rhsHash ? 0 : 1);
        }
    };
    private IConditionExpr expr;
    private List<TreeReference> targets;
    private TreeReference contextRef;
    private TreeReference originalContextRef;
    private int waveCount = 0;
    private HashSet<QuickTriggerable> immediateCascades = null;

    public void setImmediateCascades(HashSet<QuickTriggerable> cascades) {
        this.immediateCascades = new HashSet<QuickTriggerable>(cascades);
    }

    public HashSet<QuickTriggerable> getImmediateCascades() {
        return this.immediateCascades;
    }

    public Triggerable() {
    }

    public Triggerable(IConditionExpr expr, TreeReference contextRef, ArrayList<TreeReference> targets) {
        this.expr = expr;
        this.contextRef = contextRef;
        this.originalContextRef = contextRef;
        this.targets = targets;
    }

    public Triggerable(IConditionExpr expr, TreeReference contextRef) {
        this(expr, contextRef, new ArrayList<TreeReference>(0));
    }

    protected abstract Object eval(FormInstance var1, EvaluationContext var2);

    protected abstract void apply(TreeReference var1, Object var2, FormInstance var3);

    public abstract boolean canCascade();

    public final List<EvaluationResult> apply(FormInstance mainInstance, EvaluationContext parentContext, TreeReference context) {
        TreeReference ungenericised = this.originalContextRef.contextualize(context);
        EvaluationContext ec = new EvaluationContext(parentContext, ungenericised);
        Object result = this.eval(mainInstance, ec);
        ArrayList<EvaluationResult> affectedNodes = new ArrayList<EvaluationResult>(0);
        for (TreeReference target : this.targets) {
            TreeReference targetRef = target.contextualize(ec.getContextRef());
            List<TreeReference> v = ec.expandReference(targetRef);
            for (TreeReference affectedRef : v) {
                this.apply(affectedRef, result, mainInstance);
                affectedNodes.add(new EvaluationResult(affectedRef, result));
            }
        }
        return affectedNodes;
    }

    public IConditionExpr getExpr() {
        return this.expr;
    }

    public void addTarget(TreeReference target) {
        if (this.targets.indexOf(target) == -1) {
            this.targets.add(target);
        }
    }

    public List<TreeReference> getTargets() {
        return this.targets;
    }

    public void setWaveCount(int waveCount) {
        this.waveCount = waveCount;
    }

    public boolean isCascadingToChildren() {
        return false;
    }

    public Set<TreeReference> getTriggers() {
        Set<TreeReference> relTriggers = this.expr.getTriggers(null);
        HashSet<TreeReference> absTriggers = new HashSet<TreeReference>();
        for (TreeReference r : relTriggers) {
            absTriggers.add(r.anchor(this.originalContextRef));
        }
        return absTriggers;
    }

    Boolean evalPredicate(FormInstance model, EvaluationContext evalContext) {
        try {
            return new Boolean(this.expr.eval(model, evalContext));
        }
        catch (XPathException e) {
            e.setSource("Relevant expression for " + this.contextRef.toString(true));
            throw e;
        }
    }

    Object evalRaw(FormInstance model, EvaluationContext evalContext) {
        try {
            return this.expr.evalRaw(model, evalContext);
        }
        catch (XPathException e) {
            e.setSource("calculate expression for " + this.contextRef.toString(true));
            throw e;
        }
    }

    public void changeContextRefToIntersectWithTriggerable(Triggerable t) {
        this.contextRef = this.contextRef.intersect(t.contextRef);
    }

    public TreeReference contextualizeContextRef(TreeReference anchorRef) {
        return this.contextRef.contextualize(anchorRef);
    }

    public boolean equals(Object o) {
        if (o instanceof Triggerable) {
            Triggerable t = (Triggerable)o;
            if (this == t) {
                return true;
            }
            if (this.expr.equals(t.expr)) {
                try {
                    Set<TreeReference> Atriggers = this.getTriggers();
                    Set<TreeReference> Btriggers = t.getTriggers();
                    return Atriggers.size() == Btriggers.size() && Atriggers.containsAll(Btriggers);
                }
                catch (XPathException e) {
                    return false;
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
        this.expr = (IConditionExpr)ExtUtil.read(in, new ExtWrapTagged(), pf);
        this.contextRef = (TreeReference)ExtUtil.read(in, TreeReference.class, pf);
        this.originalContextRef = (TreeReference)ExtUtil.read(in, TreeReference.class, pf);
        List tlist = (List)ExtUtil.read(in, new ExtWrapList(TreeReference.class), pf);
        this.targets = new ArrayList<TreeReference>(tlist);
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        ExtUtil.write(out, new ExtWrapTagged(this.expr));
        ExtUtil.write(out, this.contextRef);
        ExtUtil.write(out, this.originalContextRef);
        ArrayList<TreeReference> tlist = new ArrayList<TreeReference>(this.targets);
        ExtUtil.write(out, new ExtWrapList(tlist));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.targets.size(); ++i) {
            sb.append(this.targets.get(i).toString());
            if (i >= this.targets.size() - 1) continue;
            sb.append(",");
        }
        return "trig[expr:" + this.expr.toString() + ";targets[" + sb.toString() + "]]";
    }

    public void print(OutputStreamWriter w) throws IOException {
        w.write("   waveCount: " + Integer.toString(this.waveCount) + "\n");
        w.write("   isCascading: " + (this.isCascadingToChildren() ? "true" : "false") + "\n");
        w.write("   expr: " + this.expr.toString() + "\n");
        w.write("   contextRef: " + (this.contextRef != null ? this.contextRef.toString(true) : "null") + "\n");
        w.write("   originalContextRef: " + (this.originalContextRef != null ? this.originalContextRef.toString(true) : "null") + "\n");
        for (int j = 0; j < this.getTargets().size(); ++j) {
            TreeReference r = this.getTargets().get(j);
            w.write("   targets[" + Integer.toString(j) + "] :" + r.toString(true) + "\n");
        }
    }

    public List<TreeReference> findAffectedTriggers(Map<TreeReference, List<TreeReference>> firedAnchorsMap) {
        ArrayList<TreeReference> affectedTriggers = new ArrayList<TreeReference>(0);
        Set<TreeReference> triggers = this.getTriggers();
        for (TreeReference trigger : triggers) {
            List<TreeReference> firedAnchors = firedAnchorsMap.get(trigger.genericize());
            if (firedAnchors == null) continue;
            affectedTriggers.addAll(firedAnchors);
        }
        return affectedTriggers;
    }
}

