/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.services;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.javarosa.core.services.IPropertyManager;
import org.javarosa.core.services.properties.IPropertyRules;
import org.javarosa.core.services.properties.Property;
import org.javarosa.core.services.storage.IStorageUtilityIndexed;
import org.javarosa.core.services.storage.StorageFullException;
import org.javarosa.core.services.storage.StorageManager;
import org.javarosa.core.util.externalizable.Externalizable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyManager
implements IPropertyManager {
    private static final Logger logger = LoggerFactory.getLogger(PropertyManager.class);
    private static IPropertyManager instance;
    public static final String STORAGE_KEY = "PROPERTY";
    private List<IPropertyRules> rulesList;
    private IStorageUtilityIndexed<? extends Externalizable> properties = (IStorageUtilityIndexed)StorageManager.getStorage("PROPERTY");

    public static void setPropertyManager(IPropertyManager pm) {
        instance = pm;
    }

    public static void initDefaultPropertyManager() {
        StorageManager.registerStorage(STORAGE_KEY, Property.class);
        PropertyManager.setPropertyManager(new PropertyManager());
    }

    public static IPropertyManager __() {
        if (instance == null) {
            PropertyManager.initDefaultPropertyManager();
        }
        return instance;
    }

    public PropertyManager() {
        this.rulesList = new ArrayList<IPropertyRules>(0);
    }

    @Override
    public String getSingularProperty(String propertyName) {
        List<String> value;
        String retVal = null;
        if ((this.rulesList.size() == 0 || this.checkPropertyAllowed(propertyName)) && (value = this.getValue(propertyName)) != null && value.size() == 1) {
            retVal = value.get(0);
        }
        if (retVal == null) {
            logger.warn("Singular property request failed for property {}", (Object)propertyName);
        }
        return retVal;
    }

    @Override
    public List<String> getProperty(String propertyName) {
        if (this.rulesList.size() == 0) {
            return this.getValue(propertyName);
        }
        if (this.checkPropertyAllowed(propertyName)) {
            return this.getValue(propertyName);
        }
        return null;
    }

    @Override
    public void setProperty(String propertyName, String propertyValue) {
        ArrayList<String> wrapper = new ArrayList<String>(1);
        wrapper.add(propertyValue);
        this.setProperty(propertyName, wrapper);
    }

    @Override
    public void setProperty(String propertyName, List<String> propertyValue) {
        List<String> oldValue = this.getProperty(propertyName);
        if (oldValue != null && this.listEquals(oldValue, propertyValue)) {
            return;
        }
        if (this.rulesList.size() == 0) {
            this.writeValue(propertyName, propertyValue);
        } else {
            boolean valid = true;
            for (String pv : propertyValue) {
                if (this.checkValueAllowed(propertyName, pv)) continue;
                valid = false;
            }
            if (valid) {
                this.writeValue(propertyName, propertyValue);
                this.notifyChanges(propertyName);
            } else {
                logger.info("Property Manager: Unable to write value ({}) to {}", (Object)propertyValue, (Object)propertyName);
            }
        }
    }

    private boolean listEquals(List<String> v1, List<String> v2) {
        if (v1.size() != v2.size()) {
            return false;
        }
        for (int i = 0; i < v1.size(); ++i) {
            if (v1.get(i).equals(v2.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<IPropertyRules> getRules() {
        return this.rulesList;
    }

    public void setRules(IPropertyRules rules) {
        this.rulesList.clear();
        this.rulesList.add(rules);
    }

    @Override
    public void addRules(IPropertyRules rules) {
        if (rules != null) {
            this.rulesList.add(rules);
        }
    }

    public boolean checkPropertyAllowed(String propertyName) {
        if (this.rulesList.size() == 0) {
            return true;
        }
        boolean allowed = false;
        for (IPropertyRules rules : this.rulesList) {
            if (!rules.checkPropertyAllowed(propertyName)) continue;
            allowed = true;
            break;
        }
        return allowed;
    }

    public boolean checkValueAllowed(String propertyName, String propertyValue) {
        if (this.rulesList.size() == 0) {
            return true;
        }
        boolean allowed = false;
        for (IPropertyRules rules : this.rulesList) {
            if (!rules.checkPropertyAllowed(propertyName) || !rules.checkValueAllowed(propertyName, propertyValue)) continue;
            allowed = true;
            break;
        }
        return allowed;
    }

    private void notifyChanges(String property) {
        if (this.rulesList.size() == 0) {
            return;
        }
        for (IPropertyRules therules : this.rulesList) {
            if (!therules.checkPropertyAllowed(property)) continue;
            therules.handlePropertyChanges(property);
        }
    }

    public List<String> getValue(String name) {
        try {
            Property p = (Property)this.properties.getRecordForValue("NAME", name);
            return p.value;
        }
        catch (NoSuchElementException nsee) {
            return null;
        }
    }

    public void writeValue(String propertyName, List<String> value) {
        Property theProp = new Property();
        theProp.name = propertyName;
        theProp.value = value;
        List<Integer> IDs = this.properties.getIDsForValue("NAME", propertyName);
        if (IDs.size() == 1) {
            theProp.setID(IDs.get(0));
        }
        try {
            this.properties.write(theProp);
        }
        catch (StorageFullException e) {
            throw new RuntimeException("uh-oh, storage full [properties]");
        }
    }
}

