/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.data;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import org.javarosa.core.model.data.IAnswerData;
import org.javarosa.core.model.data.UncastData;
import org.javarosa.core.model.utils.DateUtils;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.javarosa.xpath.IExprDataType;

public class GeoPointData
implements IAnswerData,
IExprDataType {
    public static final int REQUIRED_ARRAY_SIZE = 2;
    public static final double MISSING_VALUE = 0.0;
    public static final double NO_ACCURACY_VALUE = 9999999.0;
    private double[] gp = new double[4];
    private int len = 2;

    public GeoPointData() {
        for (int i = 2; i < this.gp.length; ++i) {
            this.gp[i] = 0.0;
        }
    }

    public GeoPointData(GeoPointData gpd) {
        this.fillArray(gpd.gp);
    }

    public GeoPointData(double[] gp) {
        this.fillArray(gp);
    }

    private void fillArray(double[] gp) {
        int i;
        this.len = gp.length;
        for (i = 0; i < this.len; ++i) {
            this.gp[i] = gp[i];
        }
        for (i = this.len; i < gp.length; ++i) {
            this.gp[i] = 0.0;
        }
    }

    @Override
    public IAnswerData clone() {
        return new GeoPointData(this.gp);
    }

    @Override
    public String getDisplayText() {
        if (!this.toBoolean().booleanValue()) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < this.len; ++i) {
            b.append(this.gp[i]);
            if (i == this.len - 1) continue;
            b.append(" ");
        }
        return b.toString();
    }

    @Override
    public Object getValue() {
        return this.gp.clone();
    }

    @Override
    public void setValue(Object o) {
        if (o == null) {
            throw new NullPointerException("Attempt to set an IAnswerData class to null.");
        }
        this.fillArray((double[])o);
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
        int i;
        this.len = (int)ExtUtil.readNumeric(in);
        for (i = 0; i < this.len; ++i) {
            this.gp[i] = ExtUtil.readDecimal(in);
        }
        for (i = this.len; i < this.gp.length; ++i) {
            this.gp[i] = 0.0;
        }
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        ExtUtil.writeNumeric(out, this.len);
        for (int i = 0; i < this.len; ++i) {
            ExtUtil.writeDecimal(out, this.gp[i]);
        }
    }

    @Override
    public UncastData uncast() {
        return new UncastData(this.getDisplayText());
    }

    @Override
    public GeoPointData cast(UncastData data) throws IllegalArgumentException {
        double[] ret = new double[4];
        for (int i = 2; i < ret.length; ++i) {
            ret[i] = 0.0;
        }
        List<String> choices = DateUtils.split(data.value, " ", true);
        int i = 0;
        for (String s : choices) {
            double d;
            ret[i] = d = Double.parseDouble(s);
            ++i;
        }
        return new GeoPointData(ret);
    }

    @Override
    public Boolean toBoolean() {
        return this.gp[0] != 0.0 || this.gp[1] != 0.0 || this.gp[2] != 0.0 || this.gp[3] != 0.0;
    }

    @Override
    public Double toNumeric() {
        if (!this.toBoolean().booleanValue()) {
            return 9999999.0;
        }
        return this.gp[3];
    }

    @Override
    public String toString() {
        return this.getDisplayText();
    }

    public double getPart(int i) {
        if (i < this.len) {
            return this.gp[i];
        }
        throw new ArrayIndexOutOfBoundsException("Cannot find coordinates part with index " + i);
    }
}

