# Copyright (c) 2026, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
# Copyright (c) 2026, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
from polaris.utils.database.db_utils import commit_and_close
from polaris.utils.database.standard_database import StandardDatabase, DatabaseType

from QPolaris import get_polaris_menu_instance
from QPolaris.modules.import_export.export_matrices import ExportMatricesDialog
from QPolaris.modules.menu_actions.show_dialog import show_diag
from QPolaris.modules.processing_provider.polaris_base_algorithm import PolarisProcessingAlgorithm


def export_matrices():
    proj = get_polaris_menu_instance()
    if not proj.open_mode or proj.open_mode != "project":
        proj.message_no_project()
    else:
        show_diag(ExportMatricesDialog(proj))
    return {}


class ExportMatrices(PolarisProcessingAlgorithm):
    def __init__(self):
        super().__init__(
            export_matrices,
            "export_matrices",
            "Export Vehicle Matrices",
            "Import-Export",
            "Import-Export",
            "Export vehicle matrices to OMX format.",
            ["Export", "matrices", "matrix", "results", "trips", "vehicles"],
        )

    def createInstance(self):
        return ExportMatrices()
