# Copyright (c) 2026, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
# Copyright (c) 2026, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
from ..traffic import ShortestPathDialog
from .show_dialog import show_diag


def traffic_shortest_path(proj):
    if not proj.open_mode or proj.open_mode != "project":
        proj.message_no_project()
        return

    message = "Loading the scenario onto the router takes time. Please wait"
    msg = proj.iface.messageBar()
    msg.pushMessage("Warning", message, level=1, duration=50)
    msg.update()
    msg.repaint()

    dlg2 = ShortestPathDialog(proj)
    msg.close()
    show_diag(dlg2)
