# Copyright (c) 2026, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
# Copyright (c) 2026, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
from polaris.utils.database.db_utils import read_and_close
from ..common_tools import QGISConsistencyEnforcer


def run_consistency(qgis_project):
    if not qgis_project.open_mode:
        qgis_project.show_message_no_supply()
        return

    sql = "select count(*) from Geo_Consistency_Controller;"
    with read_and_close(qgis_project.supply_path, spatial=True) as conn:
        if sum(conn.execute(sql).fetchone()) == 0:
            return

    cons = QGISConsistencyEnforcer(qgis_project)
    cons.execute()
