# Copyright (c) 2026, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
# Copyright (c) 2026, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
from ..polparameters import JSONEditor


def json_editor(proj):
    if not proj.open_mode or proj.open_mode != "project":
        proj.message_no_project()
        return

    base_path = proj.polaris_project.run_config.data_dir
    files = [str(file.name) for file in list(base_path.glob("*.json")) + list(base_path.glob("*.yaml"))]

    if len(files) == 0:
        proj.iface.messageBar().pushMessage(
            "Error", f"Project/iteration {base_path.name} has no parameter files", level=2, duration=15
        )
        return
    dlg2 = JSONEditor(proj)
    dlg2.show()
    dlg2.exec_()
