# Copyright (c) 2026, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
# Copyright (c) 2026, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
from polaris.utils.database.db_utils import commit_and_close
from polaris.utils.database.standard_database import StandardDatabase, DatabaseType

from QPolaris import get_polaris_menu_instance
from QPolaris.modules.menu_actions.show_dialog import show_diag
from QPolaris.modules.processing_provider.polaris_base_algorithm import PolarisProcessingAlgorithm
from QPolaris.modules.results_analysis.desire_delaunay_lines import DesireDelaunayDialog


def desire_delaunay():
    proj = get_polaris_menu_instance()
    if not proj.open_mode or proj.open_mode != "project":
        proj.message_no_project()
    else:
        show_diag(DesireDelaunayDialog(proj))
    return {}


class DesireDelaunay(PolarisProcessingAlgorithm):
    def __init__(self):
        super().__init__(
            desire_delaunay,
            "desire_delaunay",
            "Desire and Delaunay Lines",
            "Result Analysis",
            "results_analysis",
            "Creates Desire Delaunay lines for the Trips table",
            ["Desire lines", "Delaunay lines", "trips", "matrix", "analysis", "visualization", "aggregate"],
        )

    def createInstance(self):
        return DesireDelaunay()
