# Copyright (c) 2026, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
# Copyright (c) 2026, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
from QPolaris import get_polaris_menu_instance
from QPolaris.modules.common_tools import GetOutputFolderName
from QPolaris.modules.import_export.dump_dialog import DumpDialog
from QPolaris.modules.menu_actions.show_dialog import show_diag
from QPolaris.modules.processing_provider.polaris_base_algorithm import PolarisProcessingAlgorithm


def dump_to_text_action():
    proj = get_polaris_menu_instance()
    if not proj.open_mode:
        proj.show_message_no_supply()
        return {}
    folder = GetOutputFolderName()
    if not folder:
        return {}
    dlg2 = DumpDialog(proj, folder)
    show_diag(dlg2)
    return {}


class DumpToText(PolarisProcessingAlgorithm):
    def __init__(self):
        super().__init__(
            dump_to_text_action,
            "dump_to_text_dialog",
            "Dump Supply to Text",
            "Import-Export",
            "import_export",
            "Dumps the supply database to text files.",
            ["dump", "export", "text", "supply", "database"],
        )

    def createInstance(self):
        return DumpToText()
