# Copyright (c) 2026, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
# Copyright (c) 2026, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
from QPolaris import get_polaris_menu_instance
from QPolaris.modules.menu_actions.revert_link import link_revert
from QPolaris.modules.processing_provider.polaris_base_algorithm import PolarisProcessingAlgorithm
from functools import partial


class RevertLinkDialog(PolarisProcessingAlgorithm):
    def __init__(self):
        super().__init__(
            partial(link_revert, get_polaris_menu_instance()),
            "revert_link_dialog",
            "Revert Link",
            "Editing",
            "editing",
            "Reverts a link in the network.",
            ["link", "revert", "edit", "network"],
        )

    def createInstance(self):
        return RevertLinkDialog()
