# Copyright (c) 2026, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
# Copyright (c) 2026, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
from functools import partial

from QPolaris import get_polaris_menu_instance
from QPolaris.modules.menu_actions.global_geocons import global_geo_consistency
from QPolaris.modules.processing_provider.polaris_base_algorithm import PolarisProcessingAlgorithm


class GlobalGeoConsistencyDialog(PolarisProcessingAlgorithm):
    def __init__(self):
        super().__init__(
            partial(global_geo_consistency, get_polaris_menu_instance()),
            "global_geo_consistency_dialog",
            "Global GeoConsistency",
            "Model building and consistency",
            "building_and_consistency",
            "Checks and applies global geo-consistency to the network.",
            ["geo", "consistency", "geoconsistency", "network", "consistency", "supply", "edit"],
        )

    def createInstance(self):
        return GlobalGeoConsistencyDialog()
