# Copyright (c) 2026, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
# Copyright (c) 2026, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
import json
import os
from pathlib import Path

import yaml
from qgis.PyQt import QtCore, QtWidgets, uic
from qgis.core import QgsProject

FORM_CLASS, _ = uic.loadUiType(os.path.join(os.path.dirname(__file__), "forms/pop_synth.ui"))


class PopSynth(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, qgis_project):
        QtWidgets.QDialog.__init__(self)
        self.iface = qgis_project.iface
        self.setupUi(self)

        # self.tab_list_fields.addItems(files)
        # self.tab_list_fields.currentIndexChanged.connect(self.load_new_file)

        if qgis_project.open_mode:
            self._PQgis = qgis_project
            self.project = qgis_project.polaris_project
            self.base_path = self.project.run_config.data_dir

            zones = QgsProject.instance().mapLayersByName("zone")[0]
            QgsProject.instance().setCrs(zones.crs())
            zones.updateExtents()
            qgis_project.iface.mapCanvas().setExtent(zones.extent())
            qgis_project.iface.mapCanvas().refresh()
            qgis_project.iface.mapCanvas().zoomToFullExtent()

    def closeEvent(self, event):
        event.accept()
