# Copyright (c) 2026, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
# Copyright (c) 2026, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
from qgis.PyQt.QtWidgets import QDialog
from ..common_tools import GetOutputFileName


def load_demand(proj):
    if not proj.open_mode:
        proj.show_message_no_supply()
        return
    formats = ["Polaris Demand(*.sqlite)"]
    path, dtype = GetOutputFileName(
        QDialog(),
        "Polaris Demand",
        formats,
        ".sqlite",
        proj.path,
    )

    if dtype is not None:
        proj.polaris_project.set_demand_file(path)
