# Copyright (c) 2026, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
# Copyright (c) 2026, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
from qgis.core import QgsProject


def clear_intersection_display(proj):
    if not proj.open_mode:
        proj.show_message_no_supply()
        return

    root = QgsProject.instance().layerTreeRoot()
    for lyr in ["protected", "permitted", "stop_permit", "connection"]:
        if lyr in proj.layers:
            root.removeLayer(proj.layers[lyr][0])
    if "node" in proj.layers:
        proj.layers["node"][0].setSubsetString(None)
