# Copyright (c) 2026, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
# Copyright (c) 2026, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
from functools import wraps
from qgis.PyQt.QtWidgets import QWidget


def block_signals(func):
    @wraps(func)
    def wrapper(self, *args, **kwargs):
        # Block signals for all child widgets
        for child in self.findChildren(QWidget):
            child.blockSignals(True)
        try:
            result = func(self, *args, **kwargs)
        finally:
            # Unblock signals for all child widgets
            for child in self.findChildren(QWidget):
                child.blockSignals(False)
        return result

    return wrapper
