# Copyright (c) 2026, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
# Copyright (c) 2026, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE

from QPolaris import get_polaris_menu_instance
from QPolaris.modules.menu_actions import display_traffic
from QPolaris.modules.processing_provider.polaris_base_algorithm import PolarisProcessingAlgorithm
from functools import partial


class OpenLinkFlowsDialog(PolarisProcessingAlgorithm):
    def __init__(self):
        super().__init__(
            partial(display_traffic, get_polaris_menu_instance()),
            "open_link_map_dialog",
            "Traffic flow Visualization",
            "Result Analysis",
            "results_analysis",
            "Opens the traffic flow visualization tool",
            ["traffic", "flow", "result", "visualization", "links", "roads", "analysis", "compare", "iterations"],
        )

    def createInstance(self):
        return OpenLinkFlowsDialog()
