# Copyright (c) 2026, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
# Copyright (c) 2026, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
from functools import partial

from QPolaris import get_polaris_menu_instance
from QPolaris.modules.checker_interface.checker_dialog import CheckerDialog
from QPolaris.modules.menu_actions.show_dialog import show_diag
from QPolaris.modules.processing_provider.polaris_base_algorithm import PolarisProcessingAlgorithm


def checker_interface():
    proj = get_polaris_menu_instance()
    if not proj.open_mode:
        proj.show_message_no_supply()
        return {}
    dlg2 = CheckerDialog(proj)
    show_diag(dlg2)
    return {}


class CheckerInterfaceDialog(PolarisProcessingAlgorithm):
    def __init__(self):
        super().__init__(
            checker_interface,
            "checker_interface_dialog",
            "Checker Interface",
            "Model building and consistency",
            "building_and_consistency",
            "Opens the checker interface dialog.",
            ["checker", "consistency", "validation", "network", "supply"],
        )

    def createInstance(self):
        return CheckerInterfaceDialog()
