# Copyright (c) 2026, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
# Copyright (c) 2026, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
from tempfile import gettempdir

from qgis.PyQt import QtWidgets

from ..common_tools import GetOutputFileName
from contextlib import closing
from polaris.utils.database.standard_database import StandardDatabase, DatabaseType
from polaris.utils.database.spatialite_utils import connect_spatialite


def new_demand():
    new_name, _ = GetOutputFileName(
        QtWidgets.QDialog(), "New Polaris Supply file", ["Polaris network (*.sqlite)"], ".sqlite", gettempdir()
    )

    if not new_name:
        return

    with closing(connect_spatialite(new_name)) as conn:
        StandardDatabase.for_type(DatabaseType.Demand).create_tables(conn, None)
