# Copyright (c) 2026, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
# Copyright (c) 2026, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
from polaris.utils.database.db_utils import commit_and_close
from ..supply_editor import IntersectionDialog
from .show_dialog import show_diag


def intersection_navigator(proj):
    if not proj.open_mode:
        proj.show_message_no_supply()
        return
    with commit_and_close(proj.supply_path, spatial=True) as conn:
        dlg2 = IntersectionDialog(proj, conn)
        show_diag(dlg2)
