# Copyright (c) 2026, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
# Copyright (c) 2026, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
from os.path import dirname, join

from polaris.network.utils.network_dump_loader import LoadNetworkDump
from qgis.PyQt import uic
from qgis.PyQt.QtWidgets import QDialog

FORM_CLASS, _ = uic.loadUiType(join(dirname(dirname(__file__)), "common_tools/forms/progress.ui"))


class LoadFromDumpDialog(QDialog, FORM_CLASS):
    def __init__(self, _PQgis, folder):
        QDialog.__init__(self)
        self.iface = _PQgis.iface

        self.setupUi(self)
        self._PQgis = _PQgis
        self.srid = -1
        self.finished = False
        self.worker_thread = LoadNetworkDump(folder, True)
        self.load_dump()

    def load_dump(self):
        self.worker_thread.loading.connect(self.signal_handler)
        self.worker_thread.run()

    def signal_handler(self, val):
        if val[0] == "start":
            self.setWindowTitle("Loading network from archive")
            self.lbl_progress.setText(val[3])
            self.progressBar.setRange(0, val[2])
            self.progressBar.setValue(0)
        elif val[0] == "update":
            self.progressBar.setValue(val[2])
            self.lbl_progress.setText(val[3])
        elif val[0] == "finished_dumploading_procedure":
            self.lbl_progress.setText("FINISHED")
            self.finished = True
            self.close()

    def closeEvent(self, event):
        event.accept()
