# Copyright (c) 2025, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
# Copyright (c) 2025, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
from QPolaris.modules.processing_provider.polaris_base_algorithm import PolarisProcessingAlgorithm

from QPolaris import get_polaris_menu_instance
from QPolaris.modules.menu_actions.show_dialog import show_diag


def import_gmns_action():
    proj = get_polaris_menu_instance()
    from QPolaris.modules.import_export.import_gmns import ImportGMNSDialog

    dlg2 = ImportGMNSDialog(proj)
    show_diag(dlg2)
    return {}


class ImportGMNS(PolarisProcessingAlgorithm):
    def __init__(self):
        super().__init__(
            import_gmns_action,
            "import_gmns_network",
            "Import GMNS Network",
            "Import-Export",
            "import_export",
            "Imports a network from GMNS",
            ["Import", "network", "gmns", "storage", "exchange"],
        )

    def createInstance(self):
        return ImportGMNS()
