# Copyright (c) 2025, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
# Copyright (c) 2025, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
# FROM AEQUILIBRAE
from qgis.core import QgsVectorGradientColorRampV2

BlueGreenYellowRedBlack = QgsVectorGradientColorRampV2.create(
    {
        "color1": "36,219,255",  # Blue from 0 forward
        "color2": "0,0,0",  # Black at 100%
        "stops": "0.25;0,230,0:" "0.50;255,248,0:" "0.75;252,0,0",  # Green from 25% forward  # Yellow from 50% forward
    }
)  # Red from 75% forward

GreenYellowRedBlack = QgsVectorGradientColorRampV2.create(
    {
        "color1": "0,230,0",  # Green from 0% forward
        "color2": "0,0,0",  # Black at 100%
        "stops": "0.25;255,248,0:" "0.50;252,0,0",  # Yellow from 25% forward
    }
)  # Red from 50% forward


BlueGreenYellowRed = QgsVectorGradientColorRampV2.create(
    {
        "color1": " 75, 141, 255",  # Green from 0% forward
        "color2": "255, 0, 0",  # Black at 100%
        "stops": "0.25;60, 169, 76:" "0.50;206, 168, 55",  # Yellow from 25% forward
    }
)  # Red from 50% forward


color_ramps = {
    "BlueGreenYellowRedBlack": BlueGreenYellowRedBlack,
    "BlueGreenRed": BlueGreenYellowRed,
    "GreenYellowRedBlack": GreenYellowRedBlack,
}
