# Copyright (c) 2025, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
# Copyright (c) 2025, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
from QPolaris import get_polaris_menu_instance
from QPolaris.modules.processing_provider.polaris_base_algorithm import PolarisProcessingAlgorithm
from functools import partial


def load_from_text_action():
    proj = get_polaris_menu_instance()
    from QPolaris.modules.common_tools import GetOutputFolderName
    from QPolaris.modules.import_export.load_from_dump_dialog import LoadFromDumpDialog
    from QPolaris.modules.menu_actions.show_dialog import show_diag

    folder = GetOutputFolderName(message="Select source folder")
    if not folder:
        return {}
    dlg2 = LoadFromDumpDialog(proj, folder)
    show_diag(dlg2)
    return {}


class LoadFromText(PolarisProcessingAlgorithm):
    def __init__(self):
        super().__init__(
            load_from_text_action,
            "load_from_text_dialog",
            "Load supply from text",
            "Import-Export",
            "import_export",
            "Imports a supply file from csv/parquet",
            ["maintenance", "build", "import", "git", "storage", "text", "dump"],
        )

    def createInstance(self):
        return LoadFromText()
