# Copyright (c) 2025, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
# Copyright (c) 2025, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
# This portion of the script initializes the plugin, making it known to QGIS.
import os
import sys
from pathlib import Path

from .install_packages import install_requirements

install_requirements()
sys.path.insert(0, str(Path(__file__).parent / "packages"))
sys.path.insert(0, str(Path(__file__).parent))


def classFactory(iface):
    from .polaris_menu import PolarisMenu

    return PolarisMenu(iface)


# Global variable to hold the PolarisMenu instance
_polaris_menu_instance = None


def set_polaris_menu_instance(menu_instance):
    """Set the global PolarisMenu instance"""
    global _polaris_menu_instance
    _polaris_menu_instance = menu_instance


def get_polaris_menu_instance():
    """Get the global PolarisMenu instance"""
    global _polaris_menu_instance
    return _polaris_menu_instance
