# Copyright (c) 2025, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
# Copyright (c) 2025, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
from qgis.core import QgsGeometry
from ..common_tools import QGISConsistencyEnforcer


class LinkReverter:
    def __init__(self, qgis_proj):
        self.iface = qgis_proj.iface
        self._PQgis = qgis_proj
        self._p = qgis_proj.network
        self.link_layer = self._PQgis.layers["link"][0]

    def do_revert_link(self):
        if not self.link_layer.isEditable():
            print("Not editable")
            return

        print("reverting")
        for feat in self.link_layer.selectedFeatures():
            geom = feat.geometry()
            nodes = geom.asPolyline()
            nodes.reverse()
            newgeom = QgsGeometry.fromPolylineXY(nodes)
            self.link_layer.changeGeometry(feat.id(), newgeom)
        self.link_layer.commitChanges()
