# Copyright (c) 2025, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
# Copyright (c) 2025, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
from functools import partial

from QPolaris import get_polaris_menu_instance
from QPolaris.modules.menu_actions.location_links_builder import rebuild_location_links
from QPolaris.modules.processing_provider.polaris_base_algorithm import PolarisProcessingAlgorithm


class LocationLinksBuilderDialog(PolarisProcessingAlgorithm):
    def __init__(self):
        super().__init__(
            partial(rebuild_location_links, get_polaris_menu_instance()),
            "location_links_builder_dialog",
            "Location Links Builder",
            "Model building and consistency",
            "building_and_consistency",
            "Builds location links in the network.",
            ["location", "links", "builder", "consistency", "network", "supply", "edit"],
        )

    def createInstance(self):
        return LocationLinksBuilderDialog()
