# Copyright (c) 2025, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
# Copyright (c) 2025, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
from QPolaris.modules.processing_provider.polaris_base_algorithm import PolarisProcessingAlgorithm
from QPolaris import get_polaris_menu_instance


class TransitNavigatorPP(PolarisProcessingAlgorithm):
    def __init__(self):
        from QPolaris.modules.menu_actions.transit_navigator import transit_navigator

        super().__init__(
            lambda: transit_navigator(get_polaris_menu_instance()),
            "transit_navigator_dialog",
            "Transit Navigator",
            "Transit",
            "transit",
            "Opens the Transit Navigator dialog.",
            ["transit", "navigator", "network", "public transport"],
        )

    def createInstance(self):
        return TransitNavigatorPP()
