# Copyright (c) 2025, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
# Copyright (c) 2025, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
from QPolaris import get_polaris_menu_instance
from QPolaris.modules.menu_actions.transit_multimodal_path import multimodal_path
from QPolaris.modules.processing_provider.polaris_base_algorithm import PolarisProcessingAlgorithm
from functools import partial


class TransitMultimodalPathDialog(PolarisProcessingAlgorithm):
    def __init__(self):

        super().__init__(
            partial(multimodal_path, get_polaris_menu_instance()),
            "transit_multimodal_path_dialog",
            "Transit Multimodal Path",
            "Transit",
            "transit",
            "Opens the Transit Multimodal Path dialog.",
            ["transit", "multimodal", "path", "network", "public transport"],
        )

    def createInstance(self):
        return TransitMultimodalPathDialog()
