# Copyright (c) 2025, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
# Copyright (c) 2025, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
from QPolaris import get_polaris_menu_instance
from QPolaris.modules.menu_actions.plot_kpis import plt_kpis
from QPolaris.modules.processing_provider.polaris_base_algorithm import PolarisProcessingAlgorithm


class PlotKPIsDialog(PolarisProcessingAlgorithm):
    def __init__(self):
        super().__init__(
            lambda: plt_kpis(get_polaris_menu_instance()),
            "plot_kpis_dialog",
            "Plot KPIs",
            "Result Analysis",
            "results_analysis",
            "Opens the KPI plotting tool (plot_kpis)",
            ["kpi", "plot", "result", "visualization", "analysis", "compare", "iterations"],
        )

    def createInstance(self):
        return PlotKPIsDialog()
