# Copyright (c) 2025, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
# Copyright (c) 2025, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
from QPolaris import get_polaris_menu_instance
from QPolaris.modules.menu_actions.results_path_from_demand_db import path_demand_db
from QPolaris.modules.processing_provider.polaris_base_algorithm import PolarisProcessingAlgorithm


def path_from_demand_db_action():
    path_demand_db(get_polaris_menu_instance())
    return {}


class PathFromDemandDBDialog(PolarisProcessingAlgorithm):
    def __init__(self):
        super().__init__(
            path_from_demand_db_action,
            "path_from_demand_db_dialog",
            "Show Path from Demand DB",
            "Result Analysis",
            "results_analysis",
            "Opens the path visualization tool for demand DB results.",
            ["path", "demand", "result", "visualization", "analysis", "traffic"],
        )

    def createInstance(self):
        return PathFromDemandDBDialog()
