# Copyright (c) 2025, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
# Copyright (c) 2025, UChicago Argonne, LLC
# BSD OPEN SOURCE LICENSE. Full license can be found in LICENSE
from QPolaris.modules.processing_provider.polaris_base_algorithm import PolarisProcessingAlgorithm
from QPolaris import get_polaris_menu_instance
from functools import partial


class TNCNavigatorDialog(PolarisProcessingAlgorithm):
    def __init__(self):
        from QPolaris.modules.menu_actions.tnc_navigator import tnc_navigator

        super().__init__(
            partial(tnc_navigator, get_polaris_menu_instance()),
            "tnc_navigator_dialog",
            "TNC Navigator",
            "TNC",
            "tnc",
            "Opens the TNC result viewer dialog.",
            ["tnc", "navigator", "ridehail", "network"],
        )

    def createInstance(self):
        return TNCNavigatorDialog()
